/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import io.quantics.multitenant.oauth2.config.AbstractJwtGrantedAuthoritiesConverter;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.security.oauth2.resourceserver.multitenant")
public class MultiTenantResourceServerProperties {
    public static final boolean DEFAULT_ENABLED = false;
    public static final ResolveMode DEFAULT_RESOLVE_MODE = ResolveMode.JWT;
    private boolean enabled = false;
    private ResolveMode resolveMode = DEFAULT_RESOLVE_MODE;
    private Jwt jwt = new Jwt();
    private Header header = new Header();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ResolveMode getResolveMode() {
        return this.resolveMode;
    }

    public void setResolveMode(ResolveMode resolveMode) {
        this.resolveMode = resolveMode;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public static enum ResolveMode {
        JWT,
        HEADER;

    }

    public static class Jwt {
        private String authoritiesConverter;

        @PostConstruct
        void validate() throws ClassNotFoundException {
            if (this.authoritiesConverter != null && !AbstractJwtGrantedAuthoritiesConverter.class.isAssignableFrom(Class.forName(this.authoritiesConverter))) {
                throw new IllegalStateException("authoritiesConverter must implement " + AbstractJwtGrantedAuthoritiesConverter.class.getName());
            }
        }

        public String getAuthoritiesConverter() {
            return this.authoritiesConverter;
        }

        public void setAuthoritiesConverter(String authoritiesConverter) {
            this.authoritiesConverter = authoritiesConverter;
        }
    }

    public static class Header {
        public static final String DEFAULT_HEADER_NAME = "X-TENANT-ID";
        private String headerName = "X-TENANT-ID";

        public String getHeaderName() {
            return this.headerName;
        }

        public void setHeaderName(String headerName) {
            this.headerName = headerName;
        }
    }
}

