/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import io.quantics.multitenant.TenantContext;
import io.quantics.multitenant.oauth2.config.HeaderCondition;
import io.quantics.multitenant.oauth2.config.JwtCondition;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerProperties;
import io.quantics.multitenant.tenantdetails.TenantDetails;
import io.quantics.multitenant.tenantdetails.TenantDetailsService;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnMissingBean(value={WebMvcConfigurer.class})
public class MultiTenantResourceServerWebMvcConfiguration {
    private static final Log logger = LogFactory.getLog(WebMvcConfigurer.class);

    @Bean
    @Conditional(value={HeaderCondition.class})
    HandlerInterceptor multiTenantHeaderInterceptor(final MultiTenantResourceServerProperties properties, final TenantDetailsService tenantService) {
        return new HandlerInterceptor(){

            public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws IOException {
                Optional<? extends TenantDetails> tenant;
                String tenantId = request.getHeader(properties.getHeader().getHeaderName());
                if (tenantId != null && (tenant = tenantService.getById(tenantId)).isPresent()) {
                    logger.debug((Object)("Set TenantContext: " + tenant.get().getId()));
                    TenantContext.setTenantId(tenant.get().getId());
                    return true;
                }
                response.sendError(401);
                return false;
            }

            public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) {
                if (TenantContext.getTenantId() != null) {
                    logger.debug((Object)("Clear TenantContext: " + TenantContext.getTenantId()));
                    TenantContext.clear();
                }
            }
        };
    }

    @Bean
    @Conditional(value={JwtCondition.class})
    HandlerInterceptor multiTenantJwtInterceptor(final TenantDetailsService tenantService) {
        return new HandlerInterceptor(){

            public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication instanceof AbstractOAuth2TokenAuthenticationToken) {
                    AbstractOAuth2TokenAuthenticationToken token = (AbstractOAuth2TokenAuthenticationToken)authentication;
                    String issuer = (String)token.getTokenAttributes().get("iss");
                    TenantDetails tenant = tenantService.getByIssuer(issuer).orElseThrow(() -> new IllegalArgumentException("Tenant not found for issuer: " + issuer));
                    logger.debug((Object)("Set TenantContext: " + tenant.getId()));
                    TenantContext.setTenantId(tenant.getId());
                }
                return true;
            }

            public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) {
                if (TenantContext.getTenantId() != null) {
                    logger.debug((Object)("Clear TenantContext: " + TenantContext.getTenantId()));
                    TenantContext.clear();
                }
            }
        };
    }

    @Bean
    @ConditionalOnBean(value={HandlerInterceptor.class})
    WebMvcConfigurer multiTenantWebMvcConfigurer() {
        return new WebMvcConfigurer(){
            @Autowired
            private HandlerInterceptor interceptor;

            public void addInterceptors(@NonNull InterceptorRegistry registry) {
                registry.addInterceptor(this.interceptor);
            }
        };
    }
}

