/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import io.quantics.multitenant.oauth2.config.HeaderCondition;
import io.quantics.multitenant.oauth2.config.JwtCondition;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class MultiTenantResourceServerWebSecurityConfiguration {
    @Bean
    @Conditional(value={HeaderCondition.class})
    public SecurityFilterChain multiTenantHeaderFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).permitAll());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Conditional(value={JwtCondition.class})
    @ConditionalOnClass(value={AuthenticationManagerResolver.class})
    public SecurityFilterChain multiTenantJwtFilterChain(HttpSecurity http, AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver) throws Exception {
        http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).authenticated());
        http.oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(authenticationManagerResolver));
        return (SecurityFilterChain)http.build();
    }
}

