/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import com.nimbusds.jwt.JWTParser;
import io.quantics.multitenant.tenantdetails.TenantDetails;
import io.quantics.multitenant.tenantdetails.TenantDetailsService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;

public class MultiTenantAuthenticationManagerResolver
implements AuthenticationManagerResolver<HttpServletRequest> {
    private final TenantDetailsService tenantService;
    private final JwtDecoder jwtDecoder;
    private final JwtAuthenticationConverter authenticationConverter;
    private final BearerTokenResolver resolver = new DefaultBearerTokenResolver();
    private final Map<String, AuthenticationManager> authenticationManagers = new ConcurrentHashMap<String, AuthenticationManager>();

    public MultiTenantAuthenticationManagerResolver(TenantDetailsService tenantService, JwtDecoder jwtDecoder) {
        this.tenantService = tenantService;
        this.jwtDecoder = jwtDecoder;
        this.authenticationConverter = null;
    }

    public MultiTenantAuthenticationManagerResolver(TenantDetailsService tenantService, JwtDecoder jwtDecoder, JwtAuthenticationConverter authenticationConverter) {
        this.tenantService = tenantService;
        this.jwtDecoder = jwtDecoder;
        this.authenticationConverter = authenticationConverter;
    }

    public AuthenticationManager resolve(HttpServletRequest request) {
        return this.authenticationManagers.computeIfAbsent(this.toTenant(request), this::fromTenant);
    }

    private String toTenant(HttpServletRequest request) {
        try {
            String token = this.resolver.resolve(request);
            return JWTParser.parse((String)token).getJWTClaimsSet().getIssuer();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private AuthenticationManager fromTenant(String tenant) {
        return arg_0 -> ((JwtAuthenticationProvider)this.tenantService.getByIssuer(tenant).map(TenantDetails::getIssuer).map(i -> {
            JwtAuthenticationProvider provider = new JwtAuthenticationProvider(this.jwtDecoder);
            if (this.authenticationConverter != null) {
                provider.setJwtAuthenticationConverter((Converter)this.authenticationConverter);
            }
            return provider;
        }).orElseThrow(() -> new InvalidBearerTokenException("Unknown tenant: " + tenant))).authenticate(arg_0);
    }
}

