/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerJwtConfiguration;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerProperties;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerWebMvcConfiguration;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerWebSecurityConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class, SecurityAutoConfiguration.class, UserDetailsServiceAutoConfiguration.class})
@EnableConfigurationProperties(value={MultiTenantResourceServerProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MultiTenantResourceServerAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={HandlerInterceptor.class, WebMvcConfigurer.class})
    @Import(value={MultiTenantResourceServerWebMvcConfiguration.class})
    static class WebMvcConfiguration {
        WebMvcConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={SecurityFilterChain.class})
    @Import(value={MultiTenantResourceServerWebSecurityConfiguration.class})
    static class WebSecurityConfiguration {
        WebSecurityConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={JWTClaimsSetAwareJWSKeySelector.class, JWTProcessor.class, OAuth2TokenValidator.class, JwtDecoder.class, AuthenticationManagerResolver.class})
    @Import(value={MultiTenantResourceServerJwtConfiguration.class})
    static class JwtConfiguration {
        JwtConfiguration() {
        }
    }
}

