/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.micrometer.registry.azuremonitor;

import io.micrometer.azuremonitor.AzureMonitorConfig;
import io.micrometer.azuremonitor.AzureMonitorNamingConvention;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.quarkiverse.micrometer.registry.azuremonitor.AzureMonitorConfig;
import io.quarkus.arc.DefaultBean;
import io.quarkus.micrometer.runtime.export.ConfigAdapter;
import java.util.Map;
import java.util.function.Function;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;

@Singleton
public class AzureMonitorMeterRegistryProvider {
    static final String DEFAULT_REGISTRY = "quarkus.micrometer.export.azuremonitor.default-registry";
    static final String PREFIX = "azuremonitor.";
    static final String PUBLISH = "azuremonitor.publish";
    static final String ENABLED = "azuremonitor.enabled";

    @Produces
    @Singleton
    @DefaultBean
    public AzureMonitorConfig configure(AzureMonitorConfig.AzureMonitorRuntimeConfig config) {
        final Map properties = ConfigAdapter.captureProperties(config.azuremonitor, (String)PREFIX);
        if (properties.containsKey(PUBLISH)) {
            properties.put(ENABLED, (String)properties.get(PUBLISH));
        }
        return (AzureMonitorConfig)ConfigAdapter.validate((MeterRegistryConfig)new AzureMonitorConfig(){

            public String get(String key) {
                return (String)properties.get(key);
            }

            public Validated<?> validate() {
                return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"instrumentationKey", AzureMonitorConfig::instrumentationKey)});
            }
        });
    }

    @Produces
    @DefaultBean
    public AzureMonitorNamingConvention namingConvention() {
        return new AzureMonitorNamingConvention();
    }
}

