/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.micrometer.registry.influx.deployment;

import io.micrometer.influx.InfluxApiVersion;
import io.quarkiverse.micrometer.registry.influx.InfluxConfig;
import io.quarkiverse.micrometer.registry.influx.InfluxMeterRegistryProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class InfluxRegistryProcessor {
    private static final Logger log = Logger.getLogger(InfluxRegistryProcessor.class);
    public static final String REGISTRY_CLASS_NAME = "io.micrometer.influx.InfluxMeterRegistry";
    public static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.influx.InfluxMeterRegistry");

    @BuildStep(onlyIf={NativeBuild.class, InfluxRegistryEnabled.class})
    void addClassesForNativeReflection(BuildProducer<ReflectiveClassBuildItem> reflectionClasses) {
        log.warn((Object)"native support for InfluxDB meter registery is EXPERIMENTAL!!! check reflectionClasses");
        reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{InfluxApiVersion.class}));
    }

    @BuildStep(onlyIf={InfluxRegistryEnabled.class})
    public MicrometerRegistryProviderBuildItem createInfluxDBRegistry(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(InfluxMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    public static class InfluxRegistryEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;
        InfluxConfig.InfluxBuildConfig influxConfig;

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.influxConfig);
        }
    }
}

