/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.micrometer.registry.jmx.deployment;

import io.quarkiverse.micrometer.registry.jmx.JmxConfig;
import io.quarkiverse.micrometer.registry.jmx.JmxMeterRegistryProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class JmxRegistryProcessor {
    private static final Logger log = Logger.getLogger(JmxRegistryProcessor.class);
    static final String REGISTRY_CLASS_NAME = "io.micrometer.jmx.JmxMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.jmx.JmxMeterRegistry");

    @BuildStep(onlyIf={NativeBuild.class, JmxEnabled.class})
    protected MicrometerRegistryProviderBuildItem createJmxRegistry(CombinedIndexBuildItem index) {
        log.info((Object)"JMX Meter Registry does not support running in native mode.");
        return null;
    }

    @BuildStep(onlyIf={JmxEnabled.class}, onlyIfNot={NativeBuild.class})
    protected MicrometerRegistryProviderBuildItem createJmxRegistry(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JmxMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    public static class JmxEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;
        JmxConfig.JmxBuildConfig jmxConfig;

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.jmxConfig);
        }
    }
}

