/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.micrometer.registry.newrelic.deployment;

import io.quarkiverse.micrometer.registry.newrelic.NewRelicConfig;
import io.quarkiverse.micrometer.registry.newrelic.NewRelicMeterRegistryProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class NewRelicRegistryProcessor {
    private static final Logger log = Logger.getLogger(NewRelicRegistryProcessor.class);
    static final String REGISTRY_CLASS_NAME = "io.micrometer.newrelic.NewRelicMeterRegistry";
    static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.newrelic.NewRelicMeterRegistry");

    @BuildStep(onlyIf={NativeBuild.class, NewRelicEnabled.class})
    public ExtensionSslNativeSupportBuildItem enableSSLSupport() {
        log.info((Object)"The New Relic meter registry does not support running in native mode.");
        return null;
    }

    @BuildStep(onlyIf={NewRelicEnabled.class}, onlyIfNot={NativeBuild.class})
    protected MicrometerRegistryProviderBuildItem createNewRelicRegistry(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(NewRelicMeterRegistryProvider.class).setUnremovable().build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    public static class NewRelicEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;
        NewRelicConfig.NewRelicBuildConfig newRelicConfig;

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.newRelicConfig);
        }
    }
}

