/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.micrometer.registry.signalfx.deployment;

import io.quarkiverse.micrometer.registry.signalfx.ConditionalRegistryProducer;
import io.quarkiverse.micrometer.registry.signalfx.SignalFxConfig;
import io.quarkiverse.micrometer.registry.signalfx.SignalFxMeterRegistryProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

public class SignalFxRegistryProcessor {
    private static final Logger log = Logger.getLogger(SignalFxRegistryProcessor.class);
    public static final String REGISTRY_CLASS_NAME = "io.micrometer.signalfx.SignalFxMeterRegistry";
    public static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.signalfx.SignalFxMeterRegistry");

    @BuildStep(onlyIf={NativeBuild.class, SignalFxRegistryEnabled.class})
    public MicrometerRegistryProviderBuildItem nativeModeNotSupported() {
        log.info((Object)"The SignalFx meter registry does not support running in native mode.");
        return null;
    }

    @BuildStep(onlyIf={SignalFxRegistryEnabled.class}, onlyIfNot={NativeBuild.class})
    public MicrometerRegistryProviderBuildItem createSignalFxRegistry(SignalFxConfig.SignalFxBuildConfig signalFxBuildConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(SignalFxMeterRegistryProvider.class);
        if (signalFxBuildConfig.defaultRegistry) {
            builder.addBeanClass(ConditionalRegistryProducer.class);
        }
        additionalBeans.produce((BuildItem)builder.build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    public static class SignalFxRegistryEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;
        SignalFxConfig.SignalFxBuildConfig signalFxConfig;

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.signalFxConfig);
        }
    }
}

