/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.core;

import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentationMagician;
import io.quee.fragmentation.core.ISupportActivity;
import io.quee.fragmentation.core.ISupportFragment;
import io.quee.fragmentation.core.SupportActivityDelegate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u000f\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010J'\u0010\u000f\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\u0004\u0018\u0001H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0018\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010+\u001a\u00020$2\u0006\u0010(\u001a\u00020)J\u0010\u0010,\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/quee/fragmentation/core/SupportHelper;", "", "()V", "SHOW_SPACE", "", "findBackStackFragment", "T", "Lio/quee/fragmentation/core/ISupportFragment;", "fragmentClass", "Ljava/lang/Class;", "toFragmentTag", "", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "(Ljava/lang/Class;Ljava/lang/String;Landroidx/fragment/app/FragmentManager;)Lio/quee/fragmentation/core/ISupportFragment;", "findFragment", "(Landroidx/fragment/app/FragmentManager;Ljava/lang/Class;)Lio/quee/fragmentation/core/ISupportFragment;", "fragmentTag", "(Landroidx/fragment/app/FragmentManager;Ljava/lang/String;)Lio/quee/fragmentation/core/ISupportFragment;", "findStackFragment", "getActiveFragment", "parentFragment", "getBackStackTopFragment", "containerId", "", "getPreFragment", "fragment", "Landroidx/fragment/app/Fragment;", "getTopFragment", "getWillPopFragments", "", "fm", "targetTag", "includeTarget", "", "hideSoftInput", "", "view", "Landroid/view/View;", "logFragmentStackHierarchy", "support", "Lio/quee/fragmentation/core/ISupportActivity;", "TAG", "showFragmentStackHierarchyView", "showSoftInput", "fragmentation-core_release"})
public final class SupportHelper {
    @NotNull
    public static final SupportHelper INSTANCE = new SupportHelper();
    private static final long SHOW_SPACE = 200L;

    private SupportHelper() {
    }

    public final void showSoftInput(@Nullable View view) {
        if (view == null || view.getContext() == null) {
            return;
        }
        Object object = view.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        view.requestFocus();
        view.postDelayed(() -> SupportHelper.showSoftInput$lambda-0(imm, view), 200L);
    }

    public final void hideSoftInput(@Nullable View view) {
        if (view == null || view.getContext() == null) {
            return;
        }
        Object object = view.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public final void showFragmentStackHierarchyView(@NotNull ISupportActivity support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        SupportActivityDelegate supportActivityDelegate = support.getSupportDelegate();
        Intrinsics.checkNotNull((Object)supportActivityDelegate);
        supportActivityDelegate.showFragmentStackHierarchyView();
    }

    public final void logFragmentStackHierarchy(@NotNull ISupportActivity support, @Nullable String TAG) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        SupportActivityDelegate supportActivityDelegate = support.getSupportDelegate();
        Intrinsics.checkNotNull((Object)supportActivityDelegate);
        supportActivityDelegate.logFragmentStackHierarchy(TAG);
    }

    @Nullable
    public final ISupportFragment getTopFragment(@NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        return this.getTopFragment(fragmentManager, 0);
    }

    @Nullable
    public final ISupportFragment getTopFragment(@Nullable FragmentManager fragmentManager, int containerId) {
        Intrinsics.checkNotNull((Object)fragmentManager);
        List<Fragment> list = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager);
        if (list == null) {
            return null;
        }
        List<Fragment> fragmentList = list;
        int n = fragmentList.size() + -1;
        if (0 <= n) {
            do {
                int i;
                Fragment fragment;
                if (!((fragment = fragmentList.get(i = n--)) instanceof ISupportFragment)) continue;
                ISupportFragment iFragment = (ISupportFragment)fragment;
                if (containerId == 0) {
                    return iFragment;
                }
                if (containerId != iFragment.getSupportDelegate().getMContainerId()) continue;
                return iFragment;
            } while (0 <= n);
        }
        return null;
    }

    @Nullable
    public final ISupportFragment getPreFragment(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Object object = fragment.getFragmentManager();
        if (object == null) {
            return null;
        }
        Object object2 = object;
        FragmentManager fragmentManager = object2;
        if ((object = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager)) == null) {
            return null;
        }
        Object fragmentList = object;
        int index = fragmentList.indexOf(fragment);
        int n = index - 1;
        if (0 <= n) {
            do {
                int i;
                Fragment preFragment;
                if (!((preFragment = (Fragment)fragmentList.get(i = n--)) instanceof ISupportFragment)) continue;
                return (ISupportFragment)preFragment;
            } while (0 <= n);
        }
        return null;
    }

    @Nullable
    public final <T extends ISupportFragment> T findFragment(@NotNull FragmentManager fragmentManager, @Nullable Class<T> fragmentClass) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        return this.findStackFragment(fragmentClass, null, fragmentManager);
    }

    @NotNull
    public final <T extends ISupportFragment> T findFragment(@NotNull FragmentManager fragmentManager, @Nullable String fragmentTag) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        T t = this.findStackFragment(null, fragmentTag, fragmentManager);
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of io.quee.fragmentation.core.SupportHelper.findFragment");
        }
        return t;
    }

    @Nullable
    public final ISupportFragment getActiveFragment(@NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        return this.getActiveFragment(fragmentManager, null);
    }

    @Nullable
    public final <T extends ISupportFragment> T findStackFragment(@Nullable Class<T> fragmentClass, @Nullable String toFragmentTag, @NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Fragment fragment = null;
        if (toFragmentTag == null) {
            List<Fragment> fragmentList = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager);
            int sizeChildFrgList = fragmentList.size();
            int n = sizeChildFrgList - 1;
            if (0 <= n) {
                do {
                    int i;
                    Fragment brotherFragment;
                    if (!((brotherFragment = fragmentList.get(i = n--)) instanceof ISupportFragment)) continue;
                    String string = brotherFragment.getClass().getName();
                    Intrinsics.checkNotNull(fragmentClass);
                    if (!Intrinsics.areEqual((Object)string, (Object)fragmentClass.getName())) continue;
                    fragment = brotherFragment;
                    break;
                } while (0 <= n);
            }
        } else {
            fragment = fragmentManager.findFragmentByTag(toFragmentTag);
            if (fragment == null) {
                return null;
            }
        }
        return (T)((ISupportFragment)fragment);
    }

    private final ISupportFragment getActiveFragment(FragmentManager fragmentManager, ISupportFragment parentFragment) {
        List<Fragment> list = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager);
        if (list == null) {
            return parentFragment;
        }
        List<Fragment> fragmentList = list;
        int n = fragmentList.size() + -1;
        if (0 <= n) {
            do {
                int i;
                Fragment fragment;
                if (!((fragment = fragmentList.get(i = n--)) instanceof ISupportFragment) || !fragment.isResumed() || fragment.isHidden() || !fragment.getUserVisibleHint()) continue;
                FragmentManager fragmentManager2 = fragment.getChildFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentManager2, (String)"fragment.childFragmentManager");
                return this.getActiveFragment(fragmentManager2, (ISupportFragment)fragment);
            } while (0 <= n);
        }
        return parentFragment;
    }

    @Nullable
    public final ISupportFragment getBackStackTopFragment(@Nullable FragmentManager fragmentManager) {
        Intrinsics.checkNotNull((Object)fragmentManager);
        return this.getBackStackTopFragment(fragmentManager, 0);
    }

    @Nullable
    public final ISupportFragment getBackStackTopFragment(@NotNull FragmentManager fragmentManager, int containerId) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        int count = fragmentManager.getBackStackEntryCount();
        int n = count - 1;
        if (0 <= n) {
            do {
                int i = n--;
                FragmentManager.BackStackEntry backStackEntry = fragmentManager.getBackStackEntryAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)backStackEntry, (String)"fragmentManager.getBackStackEntryAt(i)");
                FragmentManager.BackStackEntry entry = backStackEntry;
                Fragment fragment = fragmentManager.findFragmentByTag(entry.getName());
                if (!(fragment instanceof ISupportFragment)) continue;
                ISupportFragment supportFragment = (ISupportFragment)fragment;
                if (containerId == 0) {
                    return supportFragment;
                }
                if (containerId != supportFragment.getSupportDelegate().getMContainerId()) continue;
                return supportFragment;
            } while (0 <= n);
        }
        return null;
    }

    @Nullable
    public final <T extends ISupportFragment> T findBackStackFragment(@NotNull Class<T> fragmentClass, @Nullable String toFragmentTag, @NotNull FragmentManager fragmentManager) {
        int n;
        Intrinsics.checkNotNullParameter(fragmentClass, (String)"fragmentClass");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        String toFragmentTag2 = toFragmentTag;
        int count = fragmentManager.getBackStackEntryCount();
        if (toFragmentTag2 == null) {
            toFragmentTag2 = fragmentClass.getName();
        }
        if (0 <= (n = count - 1)) {
            do {
                Fragment fragment;
                int i = n--;
                FragmentManager.BackStackEntry backStackEntry = fragmentManager.getBackStackEntryAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)backStackEntry, (String)"fragmentManager.getBackStackEntryAt(i)");
                FragmentManager.BackStackEntry entry = backStackEntry;
                if (!Intrinsics.areEqual((Object)toFragmentTag2, (Object)entry.getName()) || !((fragment = fragmentManager.findFragmentByTag(entry.getName())) instanceof ISupportFragment)) continue;
                return (T)((ISupportFragment)fragment);
            } while (0 <= n);
        }
        return null;
    }

    @NotNull
    public final List<Fragment> getWillPopFragments(@NotNull FragmentManager fm, @Nullable String targetTag, boolean includeTarget) {
        int i;
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Fragment target = fm.findFragmentByTag(targetTag);
        List willPopFragments = new ArrayList();
        List<Fragment> list = FragmentationMagician.INSTANCE.getActiveFragments(fm);
        if (list == null) {
            return willPopFragments;
        }
        List<Fragment> fragmentList = list;
        int size = fragmentList.size();
        int startIndex = -1;
        int n = size - 1;
        if (0 <= n) {
            do {
                if (target != fragmentList.get(i = n--)) continue;
                if (includeTarget) {
                    startIndex = i;
                    break;
                }
                if (i + 1 >= size) break;
                startIndex = i + 1;
                break;
            } while (0 <= n);
        }
        if (startIndex == -1) {
            return willPopFragments;
        }
        n = size - 1;
        if (startIndex <= n) {
            do {
                Fragment fragment;
                if ((fragment = fragmentList.get(i = n--)) == null || fragment.getView() == null) continue;
                willPopFragments.add(fragment);
            } while (i != startIndex);
        }
        return willPopFragments;
    }

    private static final void showSoftInput$lambda-0(InputMethodManager $imm, View $view) {
        Intrinsics.checkNotNullParameter((Object)$imm, (String)"$imm");
        $imm.showSoftInput($view, 2);
    }
}

