/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.core.debug;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import io.quee.fragmentation.core.R;
import io.quee.fragmentation.core.debug.DebugFragmentRecord;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J&\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\tH\u0002J(\u0010$\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001c\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010\u001aH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/quee/fragmentation/core/debug/DebugHierarchyViewContainer;", "Landroid/widget/ScrollView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mContext", "mItemHeight", "mLinearLayout", "Landroid/widget/LinearLayout;", "mPadding", "mTitleLayout", "bindFragmentRecords", "", "fragmentRecords", "", "Lio/quee/fragmentation/core/debug/DebugFragmentRecord;", "dip2px", "dp", "", "getTextView", "Landroid/widget/TextView;", "fragmentRecord", "hierarchy", "getTitleLayout", "handleExpandView", "childFragmentRecord", "finalChilHierarchy", "childTvItem", "initView", "removeView", "setView", "fragmentRecordList", "tvItem", "fragmentation-core_release"})
public final class DebugHierarchyViewContainer
extends ScrollView {
    @Nullable
    private Context mContext;
    @Nullable
    private LinearLayout mLinearLayout;
    @Nullable
    private LinearLayout mTitleLayout;
    private int mItemHeight;
    private int mPadding;

    public DebugHierarchyViewContainer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.initView(context);
    }

    public DebugHierarchyViewContainer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.initView(context);
    }

    public DebugHierarchyViewContainer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private final void initView(Context context) {
        this.mContext = context;
        HorizontalScrollView hScrollView = new HorizontalScrollView(context);
        LinearLayout linearLayout = this.mLinearLayout = new LinearLayout(context);
        Intrinsics.checkNotNull((Object)linearLayout);
        linearLayout.setOrientation(1);
        hScrollView.addView((View)this.mLinearLayout);
        this.addView((View)hScrollView);
        this.mItemHeight = this.dip2px(50.0f);
        this.mPadding = this.dip2px(16.0f);
    }

    private final int dip2px(float dp) {
        Context context = this.mContext;
        Intrinsics.checkNotNull((Object)context);
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public final void bindFragmentRecords(@Nullable List<DebugFragmentRecord> fragmentRecords) {
        LinearLayout linearLayout = this.mLinearLayout;
        Intrinsics.checkNotNull((Object)linearLayout);
        linearLayout.removeAllViews();
        LinearLayout ll = this.getTitleLayout();
        LinearLayout linearLayout2 = this.mLinearLayout;
        Intrinsics.checkNotNull((Object)linearLayout2);
        linearLayout2.addView((View)ll);
        if (fragmentRecords == null) {
            return;
        }
        this.setView(fragmentRecords, 0, null);
    }

    private final LinearLayout getTitleLayout() {
        if (this.mTitleLayout != null) {
            LinearLayout linearLayout = this.mTitleLayout;
            Intrinsics.checkNotNull((Object)linearLayout);
            return linearLayout;
        }
        LinearLayout linearLayout = this.mTitleLayout = new LinearLayout(this.mContext);
        Intrinsics.checkNotNull((Object)linearLayout);
        linearLayout.setPadding(this.dip2px(24.0f), this.dip2px(24.0f), 0, this.dip2px(8.0f));
        linearLayout = this.mTitleLayout;
        Intrinsics.checkNotNull((Object)linearLayout);
        linearLayout.setOrientation(0);
        ViewGroup.LayoutParams flParams = new ViewGroup.LayoutParams(-1, -2);
        LinearLayout linearLayout2 = this.mTitleLayout;
        Intrinsics.checkNotNull((Object)linearLayout2);
        linearLayout2.setLayoutParams(flParams);
        TextView title = new TextView(this.mContext);
        title.setText(R.string.fragmentation_stack_view);
        title.setTextSize(20.0f);
        title.setTextColor(-16777216);
        LinearLayout.LayoutParams p = new LinearLayout.LayoutParams(-2, -2);
        p.gravity = 16;
        title.setLayoutParams((ViewGroup.LayoutParams)p);
        LinearLayout linearLayout3 = this.mTitleLayout;
        Intrinsics.checkNotNull((Object)linearLayout3);
        linearLayout3.addView((View)title);
        ImageView img = new ImageView(this.mContext);
        img.setImageResource(R.drawable.fragmentation_help);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.leftMargin = this.dip2px(16.0f);
        params.gravity = 16;
        img.setLayoutParams((ViewGroup.LayoutParams)params);
        LinearLayout linearLayout4 = this.mTitleLayout;
        Intrinsics.checkNotNull((Object)linearLayout4);
        linearLayout4.setOnClickListener(arg_0 -> DebugHierarchyViewContainer.getTitleLayout$lambda-0(this, arg_0));
        linearLayout4 = this.mTitleLayout;
        Intrinsics.checkNotNull((Object)linearLayout4);
        linearLayout4.addView((View)img);
        linearLayout4 = this.mTitleLayout;
        Intrinsics.checkNotNull((Object)linearLayout4);
        return linearLayout4;
    }

    private final void setView(List<DebugFragmentRecord> fragmentRecordList, int hierarchy, TextView tvItem) {
        int n = fragmentRecordList.size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                DebugFragmentRecord child = fragmentRecordList.get(i);
                int tempHierarchy = hierarchy;
                TextView childTvItem = null;
                childTvItem = this.getTextView(child, tempHierarchy);
                childTvItem.setTag(R.id.hierarchy, (Object)tempHierarchy);
                List<DebugFragmentRecord> childFragmentRecord = child.getChildFragmentRecord();
                Collection collection = childFragmentRecord;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    int n2 = tempHierarchy;
                    tempHierarchy = n2 + 1;
                    childTvItem.setCompoundDrawablesWithIntrinsicBounds(R.drawable.fragmentation_ic_right, 0, 0, 0);
                    int finalChilHierarchy = tempHierarchy;
                    childTvItem.setOnClickListener(arg_0 -> DebugHierarchyViewContainer.setView$lambda-1(childTvItem, this, finalChilHierarchy, childFragmentRecord, arg_0));
                } else {
                    childTvItem.setPadding(childTvItem.getPaddingLeft() + this.mPadding, 0, this.mPadding, 0);
                }
                if (tvItem == null) {
                    collection = this.mLinearLayout;
                    Intrinsics.checkNotNull((Object)collection);
                    collection.addView((View)childTvItem);
                    continue;
                }
                collection = this.mLinearLayout;
                Intrinsics.checkNotNull((Object)collection);
                Collection collection2 = collection;
                View view = (View)childTvItem;
                collection = this.mLinearLayout;
                Intrinsics.checkNotNull((Object)collection);
                collection2.addView(view, collection.indexOfChild((View)tvItem) + 1);
            } while (0 <= n);
        }
    }

    private final void handleExpandView(List<DebugFragmentRecord> childFragmentRecord, int finalChilHierarchy, TextView childTvItem) {
        this.setView(childFragmentRecord, finalChilHierarchy, childTvItem);
        childTvItem.setCompoundDrawablesWithIntrinsicBounds(R.drawable.fragmentation_ic_expandable, 0, 0, 0);
    }

    private final void removeView(int hierarchy) {
        LinearLayout linearLayout = this.mLinearLayout;
        Intrinsics.checkNotNull((Object)linearLayout);
        int size = linearLayout.getChildCount();
        int n = size - 1;
        if (0 <= n) {
            do {
                int i = n--;
                Object object = this.mLinearLayout;
                Intrinsics.checkNotNull((Object)object);
                View view = object.getChildAt(i);
                if (view.getTag(R.id.hierarchy) == null) continue;
                object = view.getTag(R.id.hierarchy);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                if ((Integer)object < hierarchy) continue;
                object = this.mLinearLayout;
                Intrinsics.checkNotNull((Object)object);
                object.removeView(view);
            } while (0 <= n);
        }
    }

    private final TextView getTextView(DebugFragmentRecord fragmentRecord, int hierarchy) {
        TextView tvItem = new TextView(this.mContext);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, this.mItemHeight);
        tvItem.setLayoutParams(params);
        if (hierarchy == 0) {
            tvItem.setTextColor(Color.parseColor((String)"#333333"));
            tvItem.setTextSize(16.0f);
        }
        tvItem.setGravity(16);
        tvItem.setPadding((int)((double)this.mPadding + (double)(hierarchy * this.mPadding) * 1.5), 0, this.mPadding, 0);
        tvItem.setCompoundDrawablePadding(this.mPadding / 2);
        Object object = this.mContext;
        Intrinsics.checkNotNull((Object)object);
        Context context = object;
        object = new int[1];
        object[0] = (Context)R.attr.selectableItemBackground;
        TypedArray typedArray = context.obtainStyledAttributes((int[])object);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"mContext!!.obtainStyledAttributes(intArrayOf(R.attr.selectableItemBackground))");
        TypedArray a = typedArray;
        tvItem.setBackground(a.getDrawable(0));
        a.recycle();
        tvItem.setText(fragmentRecord.getFragmentName());
        return tvItem;
    }

    private static final void getTitleLayout$lambda-0(DebugHierarchyViewContainer this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Toast.makeText((Context)this$0.mContext, (int)R.string.fragmentation_stack_help, (int)1).show();
    }

    private static final void setView$lambda-1(TextView $childTvItem, DebugHierarchyViewContainer this$0, int $finalChilHierarchy, List $childFragmentRecord, View v) {
        Intrinsics.checkNotNullParameter((Object)$childTvItem, (String)"$childTvItem");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$childFragmentRecord, (String)"$childFragmentRecord");
        if (v.getTag(R.id.isexpand) != null) {
            Object object = v.getTag(R.id.isexpand);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean isExpand = (Boolean)object;
            if (isExpand) {
                $childTvItem.setCompoundDrawablesWithIntrinsicBounds(R.drawable.fragmentation_ic_right, 0, 0, 0);
                this$0.removeView($finalChilHierarchy);
            } else {
                this$0.handleExpandView($childFragmentRecord, $finalChilHierarchy, $childTvItem);
            }
            v.setTag(R.id.isexpand, (Object)(!isExpand ? 1 : 0));
        } else {
            $childTvItem.setTag(R.id.isexpand, (Object)true);
            this$0.handleExpandView($childFragmentRecord, $finalChilHierarchy, $childTvItem);
        }
    }
}

