/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.core.debug;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentationMagician;
import io.quee.fragmentation.core.ISupportFragment;
import io.quee.fragmentation.core.R;
import io.quee.fragmentation.core.debug.DebugFragmentRecord;
import io.quee.fragmentation.core.debug.DebugHierarchyViewContainer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001a\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001cJ\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J,\u0010$\u001a\u00020\u000b2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00122\n\u0010&\u001a\u00060'j\u0002`(2\u0006\u0010)\u001a\u00020\u001cH\u0002J\u0006\u0010*\u001a\u00020\u000bJ\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/quee/fragmentation/core/debug/DebugStackDelegate;", "Landroid/hardware/SensorEventListener;", "activity", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;)V", "mActivity", "mSensorManager", "Landroid/hardware/SensorManager;", "mStackDialog", "Landroidx/appcompat/app/AlertDialog;", "addDebugFragmentRecord", "", "fragmentRecords", "", "Lio/quee/fragmentation/core/debug/DebugFragmentRecord;", "fragment", "Landroidx/fragment/app/Fragment;", "getChildFragmentRecords", "", "parentFragment", "getFragmentRecords", "logFragmentRecords", "tag", "", "onAccuracyChanged", "sensor", "Landroid/hardware/Sensor;", "accuracy", "", "onCreate", "mode", "onDestroy", "onPostCreate", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "processChildLog", "fragmentRecordList", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "childHierarchy", "showFragmentStackHierarchyView", "span", "", "name", "str", "StackViewTouchListener", "fragmentation-core_release"})
public final class DebugStackDelegate
implements SensorEventListener {
    @NotNull
    private final FragmentActivity mActivity;
    @Nullable
    private SensorManager mSensorManager;
    @Nullable
    private AlertDialog mStackDialog;

    public DebugStackDelegate(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.mActivity = activity;
    }

    public final void onCreate(int mode) {
        if (mode != 1) {
            return;
        }
        Object object = this.mActivity.getSystemService("sensor");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        this.mSensorManager = (SensorManager)object;
        object = this.mSensorManager;
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        SensorEventListener sensorEventListener = this;
        object = this.mSensorManager;
        Intrinsics.checkNotNull((Object)object);
        object2.registerListener(sensorEventListener, object.getDefaultSensor(1), 3);
    }

    public final void onPostCreate(int mode) {
        if (mode != 2) {
            return;
        }
        View root = this.mActivity.findViewById(R.id.content);
        if (root instanceof FrameLayout) {
            ImageView stackView = new ImageView((Context)this.mActivity);
            stackView.setImageResource(R.drawable.fragmentation_ic_stack);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 0x800005;
            int dp18 = (int)TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)this.mActivity.getResources().getDisplayMetrics());
            params.topMargin = dp18 * 7;
            params.rightMargin = dp18;
            stackView.setLayoutParams((ViewGroup.LayoutParams)params);
            ((FrameLayout)root).addView((View)stackView);
            stackView.setOnTouchListener((View.OnTouchListener)new StackViewTouchListener((View)stackView, dp18 / 4));
            stackView.setOnClickListener(arg_0 -> DebugStackDelegate.onPostCreate$lambda-0(this, arg_0));
        }
    }

    public final void onDestroy() {
        if (this.mSensorManager != null) {
            SensorManager sensorManager = this.mSensorManager;
            Intrinsics.checkNotNull((Object)sensorManager);
            sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int sensorType = event.sensor.getType();
        float[] values = event.values;
        if (sensorType == 1) {
            int value = 12;
            if (Math.abs(values[0]) >= (float)value || Math.abs(values[1]) >= (float)value || Math.abs(values[2]) >= (float)value) {
                this.showFragmentStackHierarchyView();
            }
        }
    }

    public void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
    }

    public final void showFragmentStackHierarchyView() {
        if (this.mStackDialog != null) {
            AlertDialog alertDialog = this.mStackDialog;
            Intrinsics.checkNotNull((Object)alertDialog);
            if (alertDialog.isShowing()) {
                return;
            }
        }
        DebugHierarchyViewContainer container = new DebugHierarchyViewContainer((Context)this.mActivity);
        container.bindFragmentRecords(this.getFragmentRecords());
        container.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        AlertDialog alertDialog = this.mStackDialog = new AlertDialog.Builder((Context)this.mActivity).setView((View)container).setPositiveButton(R.string.cancel, null).setCancelable(true).create();
        Intrinsics.checkNotNull((Object)alertDialog);
        alertDialog.show();
    }

    public final void logFragmentRecords(@Nullable String tag) {
        List<DebugFragmentRecord> list = this.getFragmentRecords();
        if (list == null) {
            return;
        }
        List<DebugFragmentRecord> fragmentRecordList = list;
        StringBuilder sb = new StringBuilder();
        int n = fragmentRecordList.size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                DebugFragmentRecord fragmentRecord = fragmentRecordList.get(i);
                if (i == fragmentRecordList.size() - 1) {
                    sb.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
                    if (i == 0) {
                        sb.append("\t\u6808\u9876\t\t\t").append(fragmentRecord.getFragmentName()).append("\n");
                        sb.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    } else {
                        sb.append("\t\u6808\u9876\t\t\t").append(fragmentRecord.getFragmentName()).append("\n\n");
                    }
                } else {
                    if (i == 0) {
                        sb.append("\t\u6808\u5e95\t\t\t").append(fragmentRecord.getFragmentName()).append("\n\n");
                        this.processChildLog(fragmentRecord.getChildFragmentRecord(), sb, 1);
                        sb.append("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                        Log.i((String)tag, (String)sb.toString());
                        return;
                    }
                    sb.append("\t\u2193\t\t\t").append(fragmentRecord.getFragmentName()).append("\n\n");
                }
                this.processChildLog(fragmentRecord.getChildFragmentRecord(), sb, 1);
            } while (0 <= n);
        }
    }

    private final List<DebugFragmentRecord> getFragmentRecords() {
        List fragmentRecordList = new ArrayList();
        FragmentManager fragmentManager = this.mActivity.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"mActivity.supportFragmentManager");
        List<Fragment> fragmentList = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager);
        if (fragmentList.isEmpty()) {
            return null;
        }
        for (Fragment fragment : fragmentList) {
            this.addDebugFragmentRecord(fragmentRecordList, fragment);
        }
        return fragmentRecordList;
    }

    private final void processChildLog(List<DebugFragmentRecord> fragmentRecordList, StringBuilder sb, int childHierarchy) {
        int childHierarchy2 = childHierarchy;
        if (fragmentRecordList == null || fragmentRecordList.size() == 0) {
            return;
        }
        int n = 0;
        int n2 = fragmentRecordList.size() + -1;
        if (n <= n2) {
            do {
                int j = n++;
                DebugFragmentRecord childFragmentRecord = fragmentRecordList.get(j);
                int n3 = 0;
                if (n3 < childHierarchy2) {
                    do {
                        int k = n3++;
                        sb.append("\t\t\t");
                    } while (n3 < childHierarchy2);
                }
                if (j == 0) {
                    sb.append("\tSubstack top\t\t").append(childFragmentRecord.getFragmentName()).append("\n\n");
                } else {
                    if (j == fragmentRecordList.size() - 1) {
                        sb.append("\tBottom of substack\t\t").append(childFragmentRecord.getFragmentName()).append("\n\n");
                        this.processChildLog(childFragmentRecord.getChildFragmentRecord(), sb, ++childHierarchy2);
                        return;
                    }
                    sb.append("\t\u2193\t\t\t").append(childFragmentRecord.getFragmentName()).append("\n\n");
                }
                this.processChildLog(childFragmentRecord.getChildFragmentRecord(), sb, childHierarchy2);
            } while (n <= n2);
        }
    }

    private final List<DebugFragmentRecord> getChildFragmentRecords(Fragment parentFragment) {
        List fragmentRecords = new ArrayList();
        FragmentManager fragmentManager = parentFragment.getChildFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"parentFragment.childFragmentManager");
        List<Fragment> fragmentList = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager);
        if (fragmentList.isEmpty()) {
            return null;
        }
        int n = fragmentList.size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                Fragment fragment = fragmentList.get(i);
                this.addDebugFragmentRecord(fragmentRecords, fragment);
            } while (0 <= n);
        }
        return fragmentRecords;
    }

    private final void addDebugFragmentRecord(List<DebugFragmentRecord> fragmentRecords, Fragment fragment) {
        if (fragment != null) {
            FragmentManager fragmentManager = fragment.getFragmentManager();
            Intrinsics.checkNotNull((Object)fragmentManager);
            int backStackCount = fragmentManager.getBackStackEntryCount();
            Object object = fragment.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fragment.javaClass.simpleName");
            CharSequence name = (CharSequence)object;
            if (backStackCount == 0) {
                name = this.span(name, " *");
            } else {
                int n = 0;
                if (n < backStackCount) {
                    do {
                        int j = n++;
                        FragmentManager fragmentManager2 = fragment.getFragmentManager();
                        Intrinsics.checkNotNull((Object)fragmentManager2);
                        FragmentManager.BackStackEntry backStackEntry = fragmentManager2.getBackStackEntryAt(j);
                        Intrinsics.checkNotNullExpressionValue((Object)backStackEntry, (String)"fragment.fragmentManager!!.getBackStackEntryAt(j)");
                        FragmentManager.BackStackEntry entry = backStackEntry;
                        if (entry.getName() != null && Intrinsics.areEqual((Object)entry.getName(), (Object)fragment.getTag()) || entry.getName() == null && fragment.getTag() == null) break;
                        if (j != backStackCount - 1) continue;
                        name = this.span(name, " *");
                    } while (n < backStackCount);
                }
            }
            if (fragment instanceof ISupportFragment && ((ISupportFragment)fragment).isSupportVisible()) {
                name = this.span(name, " \u2600");
            }
            object = this.getChildFragmentRecords(fragment);
            Intrinsics.checkNotNull((Object)object);
            fragmentRecords.add(new DebugFragmentRecord(name, (List<DebugFragmentRecord>)object));
        }
    }

    private final CharSequence span(CharSequence name, String str) {
        CharSequence name2 = name;
        name2 = name2 + str;
        return name2;
    }

    private static final void onPostCreate$lambda-0(DebugStackDelegate this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.showFragmentStackHierarchyView();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/quee/fragmentation/core/debug/DebugStackDelegate$StackViewTouchListener;", "Landroid/view/View$OnTouchListener;", "stackView", "Landroid/view/View;", "clickLimitValue", "", "(Lio/quee/fragmentation/core/debug/DebugStackDelegate;Landroid/view/View;I)V", "dX", "", "dY", "downX", "downY", "isClickState", "", "onTouch", "v", "event", "Landroid/view/MotionEvent;", "fragmentation-core_release"})
    private final class StackViewTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final View stackView;
        private final int clickLimitValue;
        private float dX;
        private float dY;
        private float downX;
        private float downY;
        private boolean isClickState;

        public StackViewTouchListener(View stackView, int clickLimitValue) {
            Intrinsics.checkNotNullParameter((Object)DebugStackDelegate.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)stackView, (String)"stackView");
            this.stackView = stackView;
            this.clickLimitValue = clickLimitValue;
        }

        public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            float X = event.getRawX();
            float Y = event.getRawY();
            int n = event.getAction();
            switch (n) {
                case 0: {
                    this.isClickState = true;
                    this.downX = X;
                    this.downY = Y;
                    this.dX = this.stackView.getX() - event.getRawX();
                    this.dY = this.stackView.getY() - event.getRawY();
                    break;
                }
                case 2: {
                    if (Math.abs(X - this.downX) < (float)this.clickLimitValue && Math.abs(Y - this.downY) < (float)this.clickLimitValue && this.isClickState) {
                        this.isClickState = true;
                        break;
                    }
                    this.isClickState = false;
                    this.stackView.setX(event.getRawX() + this.dX);
                    this.stackView.setY(event.getRawY() + this.dY);
                    break;
                }
                case 1: 
                case 3: {
                    if (!(X - this.downX < (float)this.clickLimitValue) || !this.isClickState) break;
                    this.stackView.performClick();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }
}

