/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.core.helper.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentationMagician;
import io.quee.fragmentation.core.ISupportFragment;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0012\u0010#\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u0017J\u0010\u0010&\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u0017J\u0006\u0010'\u001a\u00020\u001dJ\b\u0010(\u001a\u00020\u001dH\u0002J\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\u001dJ\u0006\u0010,\u001a\u00020\u001dJ\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0017J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u000e\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\nR\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/quee/fragmentation/core/helper/internal/VisibleDelegate;", "", "fragment", "Lio/quee/fragmentation/core/ISupportFragment;", "(Lio/quee/fragmentation/core/ISupportFragment;)V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "isParentInvisible", "", "()Z", "<set-?>", "isSupportVisible", "mAbortInitVisible", "mFirstCreateViewCompatReplace", "mFragment", "Landroidx/fragment/app/Fragment;", "mHandler", "mInvisibleWhenLeave", "mIsFirstVisible", "mNeedDispatch", "mSaveInstanceState", "Landroid/os/Bundle;", "mSupportF", "taskDispatchSupportVisible", "Ljava/lang/Runnable;", "checkAddState", "dispatchChild", "", "visible", "dispatchChildOnFragmentShownWhenNotResumed", "dispatchSupportVisible", "enqueueDispatchVisible", "initVisible", "isFragmentVisible", "onActivityCreated", "savedInstanceState", "onCreate", "onDestroyView", "onFragmentShownWhenNotResumed", "onHiddenChanged", "hidden", "onPause", "onResume", "onSaveInstanceState", "outState", "safeDispatchUserVisibleHint", "setUserVisibleHint", "isVisibleToUser", "Companion", "fragmentation-core_release"})
public final class VisibleDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isSupportVisible;
    private boolean mNeedDispatch;
    private boolean mInvisibleWhenLeave;
    private boolean mIsFirstVisible;
    private boolean mFirstCreateViewCompatReplace;
    private boolean mAbortInitVisible;
    @Nullable
    private Runnable taskDispatchSupportVisible;
    @Nullable
    private Handler mHandler;
    @Nullable
    private Bundle mSaveInstanceState;
    @NotNull
    private final ISupportFragment mSupportF;
    @NotNull
    private final Fragment mFragment;
    @NotNull
    private static final String FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE = "fragmentation_invisible_when_leave";
    @NotNull
    private static final String FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE = "fragmentation_compat_replace";

    public VisibleDelegate(@NotNull ISupportFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.mNeedDispatch = true;
        this.mIsFirstVisible = true;
        this.mFirstCreateViewCompatReplace = true;
        this.mSupportF = fragment;
        this.mFragment = (Fragment)fragment;
    }

    public final boolean isSupportVisible() {
        return this.isSupportVisible;
    }

    public final void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mSaveInstanceState = savedInstanceState;
            this.mInvisibleWhenLeave = savedInstanceState.getBoolean(FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE);
            this.mFirstCreateViewCompatReplace = savedInstanceState.getBoolean(FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE);
        }
    }

    public final void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putBoolean(FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE, this.mInvisibleWhenLeave);
        outState.putBoolean(FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE, this.mFirstCreateViewCompatReplace);
    }

    public final void onActivityCreated(@Nullable Bundle savedInstanceState) {
        if (!this.mFirstCreateViewCompatReplace && this.mFragment.getTag() != null) {
            String string2 = this.mFragment.getTag();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2;
            if (StringsKt.startsWith$default((String)string3, (String)"android:switcher:", (boolean)false, (int)2, null)) {
                return;
            }
        }
        if (this.mFirstCreateViewCompatReplace) {
            this.mFirstCreateViewCompatReplace = false;
        }
        this.initVisible();
    }

    private final void initVisible() {
        if (!this.mInvisibleWhenLeave && !this.mFragment.isHidden() && this.mFragment.getUserVisibleHint() && (this.mFragment.getParentFragment() != null && this.isFragmentVisible(this.mFragment.getParentFragment()) || this.mFragment.getParentFragment() == null)) {
            this.mNeedDispatch = false;
            this.safeDispatchUserVisibleHint(true);
        }
    }

    public final void onResume() {
        if (!this.mIsFirstVisible) {
            if (!this.isSupportVisible && !this.mInvisibleWhenLeave && this.isFragmentVisible(this.mFragment)) {
                this.mNeedDispatch = false;
                this.dispatchSupportVisible(true);
            }
        } else if (this.mAbortInitVisible) {
            this.mAbortInitVisible = false;
            this.initVisible();
        }
    }

    public final void onPause() {
        if (this.taskDispatchSupportVisible != null) {
            Handler handler = this.getHandler();
            Runnable runnable = this.taskDispatchSupportVisible;
            Intrinsics.checkNotNull((Object)runnable);
            handler.removeCallbacks(runnable);
            this.mAbortInitVisible = true;
            return;
        }
        if (this.isSupportVisible && this.isFragmentVisible(this.mFragment)) {
            this.mNeedDispatch = false;
            this.mInvisibleWhenLeave = false;
            this.dispatchSupportVisible(false);
        } else {
            this.mInvisibleWhenLeave = true;
        }
    }

    public final void onHiddenChanged(boolean hidden) {
        if (!hidden && !this.mFragment.isResumed()) {
            this.onFragmentShownWhenNotResumed();
            return;
        }
        if (hidden) {
            this.safeDispatchUserVisibleHint(false);
        } else {
            this.enqueueDispatchVisible();
        }
    }

    private final void onFragmentShownWhenNotResumed() {
        this.mInvisibleWhenLeave = false;
        this.dispatchChildOnFragmentShownWhenNotResumed();
    }

    private final void dispatchChildOnFragmentShownWhenNotResumed() {
        FragmentManager fragmentManager = this.mFragment.getChildFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"mFragment.childFragmentManager");
        FragmentManager fragmentManager2 = fragmentManager;
        List<Fragment> childFragments = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager2);
        if (childFragments != null) {
            for (Fragment child : childFragments) {
                if (!(child instanceof ISupportFragment) || child.isHidden() || !child.getUserVisibleHint()) continue;
                ((ISupportFragment)child).getSupportDelegate().getVisibleDelegate().onFragmentShownWhenNotResumed();
            }
        }
    }

    public final void onDestroyView() {
        this.mIsFirstVisible = true;
    }

    public final void setUserVisibleHint(boolean isVisibleToUser) {
        if (this.mFragment.isResumed() || !this.mFragment.isAdded() && isVisibleToUser) {
            if (!this.isSupportVisible && isVisibleToUser) {
                this.safeDispatchUserVisibleHint(true);
            } else if (this.isSupportVisible && !isVisibleToUser) {
                this.dispatchSupportVisible(false);
            }
        }
    }

    private final void safeDispatchUserVisibleHint(boolean visible) {
        if (this.mIsFirstVisible) {
            if (!visible) {
                return;
            }
            this.enqueueDispatchVisible();
        } else {
            this.dispatchSupportVisible(visible);
        }
    }

    private final void enqueueDispatchVisible() {
        this.taskDispatchSupportVisible = () -> VisibleDelegate.enqueueDispatchVisible$lambda-0(this);
        Handler handler = this.getHandler();
        Runnable runnable = this.taskDispatchSupportVisible;
        Intrinsics.checkNotNull((Object)runnable);
        handler.post(runnable);
    }

    private final void dispatchSupportVisible(boolean visible) {
        if (visible && this.isParentInvisible()) {
            return;
        }
        if (this.isSupportVisible == visible) {
            this.mNeedDispatch = true;
            return;
        }
        this.isSupportVisible = visible;
        if (visible) {
            if (this.checkAddState()) {
                return;
            }
            this.mSupportF.onSupportVisible();
            if (this.mIsFirstVisible) {
                this.mIsFirstVisible = false;
                this.mSupportF.onLazyInitView(this.mSaveInstanceState);
            }
            this.dispatchChild(true);
        } else {
            this.dispatchChild(false);
            this.mSupportF.onSupportInvisible();
        }
    }

    private final void dispatchChild(boolean visible) {
        if (!this.mNeedDispatch) {
            this.mNeedDispatch = true;
        } else {
            if (this.checkAddState()) {
                return;
            }
            FragmentManager fragmentManager = this.mFragment.getChildFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"mFragment.childFragmentManager");
            FragmentManager fragmentManager2 = fragmentManager;
            List<Fragment> childFragments = FragmentationMagician.INSTANCE.getActiveFragments(fragmentManager2);
            if (childFragments != null) {
                for (Fragment child : childFragments) {
                    if (!(child instanceof ISupportFragment) || child.isHidden() || !child.getUserVisibleHint()) continue;
                    ((ISupportFragment)child).getSupportDelegate().getVisibleDelegate().dispatchSupportVisible(visible);
                }
            }
        }
    }

    private final boolean isParentInvisible() {
        Fragment parentFragment = this.mFragment.getParentFragment();
        return parentFragment instanceof ISupportFragment ? !((ISupportFragment)parentFragment).isSupportVisible() : parentFragment != null && !parentFragment.isVisible();
    }

    private final boolean checkAddState() {
        if (!this.mFragment.isAdded()) {
            this.isSupportVisible = !this.isSupportVisible;
            return true;
        }
        return false;
    }

    private final boolean isFragmentVisible(Fragment fragment) {
        Intrinsics.checkNotNull((Object)fragment);
        return !fragment.isHidden() && fragment.getUserVisibleHint();
    }

    private final Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        Handler handler = this.mHandler;
        Intrinsics.checkNotNull((Object)handler);
        return handler;
    }

    private static final void enqueueDispatchVisible$lambda-0(VisibleDelegate this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.taskDispatchSupportVisible = null;
        this$0.dispatchSupportVisible(true);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/quee/fragmentation/core/helper/internal/VisibleDelegate$Companion;", "", "()V", "FRAGMENTATION_STATE_SAVE_COMPAT_REPLACE", "", "FRAGMENTATION_STATE_SAVE_IS_INVISIBLE_WHEN_LEAVE", "fragmentation-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

