/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.core.queue;

import android.os.Handler;
import android.os.Looper;
import io.quee.fragmentation.core.ISupportFragment;
import io.quee.fragmentation.core.SupportHelper;
import io.quee.fragmentation.core.queue.Action;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/quee/fragmentation/core/queue/ActionQueue;", "", "mMainHandler", "Landroid/os/Handler;", "(Landroid/os/Handler;)V", "mQueue", "Ljava/util/Queue;", "Lio/quee/fragmentation/core/queue/Action;", "enqueue", "", "action", "enqueueAction", "executeNextAction", "handleAction", "isThrottleBACK", "", "fragmentation-core_release"})
public final class ActionQueue {
    @NotNull
    private final Handler mMainHandler;
    @NotNull
    private final Queue<Action> mQueue;

    public ActionQueue(@NotNull Handler mMainHandler) {
        Intrinsics.checkNotNullParameter((Object)mMainHandler, (String)"mMainHandler");
        this.mMainHandler = mMainHandler;
        this.mQueue = new LinkedList();
    }

    public final void enqueue(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (this.isThrottleBACK(action)) {
            return;
        }
        if (action.getAction() == 4 && this.mQueue.isEmpty() && Thread.currentThread() == Looper.getMainLooper().getThread()) {
            action.run();
            return;
        }
        this.mMainHandler.post(() -> ActionQueue.enqueue$lambda-0(this, action));
    }

    private final void enqueueAction(Action action) {
        this.mQueue.add(action);
        if (this.mQueue.size() == 1) {
            this.handleAction();
        }
    }

    private final void handleAction() {
        if (this.mQueue.isEmpty()) {
            return;
        }
        Action action = this.mQueue.peek();
        action.run();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"action");
        this.executeNextAction(action);
    }

    private final void executeNextAction(Action action) {
        if (action.getAction() == 1) {
            ISupportFragment iSupportFragment = SupportHelper.INSTANCE.getBackStackTopFragment(action.getFragmentManager());
            Intrinsics.checkNotNull((Object)iSupportFragment);
            ISupportFragment top = iSupportFragment;
            action.setDuration(top.getSupportDelegate().getExitAnimDuration());
        }
        this.mMainHandler.postDelayed(() -> ActionQueue.executeNextAction$lambda-1(this), action.getDuration());
    }

    private final boolean isThrottleBACK(Action action) {
        Action head;
        return action.getAction() == 3 && (head = this.mQueue.peek()) != null && head.getAction() == 1;
    }

    private static final void enqueue$lambda-0(ActionQueue this$0, Action $action) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        this$0.enqueueAction($action);
    }

    private static final void executeNextAction$lambda-1(ActionQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.mQueue.poll();
        this$0.handleAction();
    }
}

