/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.FloatRange;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentationMagician;
import io.quee.fragmentation.core.ISupportFragment;
import io.quee.fragmentation.swipeback.R;
import io.quee.fragmentation.swipeback.core.ISwipeBackActivity;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 c2\u00020\u0001:\u0005cdefgB'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0019J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\nJ\u001a\u00101\u001a\u00020-2\b\u00102\u001a\u0004\u0018\u00010\u00152\b\u00103\u001a\u0004\u0018\u00010\u0010J\b\u00104\u001a\u00020-H\u0016J \u00105\u001a\u00020\f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0014J\u0018\u0010;\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0010H\u0002J\u0018\u0010<\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0010H\u0002J\u0006\u0010=\u001a\u00020-J\b\u0010>\u001a\u00020-H\u0002J\u0006\u0010?\u001a\u00020-J\b\u0010@\u001a\u00020-H\u0002J\u0010\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020CH\u0016J0\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u0007H\u0014J\u0010\u0010J\u001a\u00020\f2\u0006\u0010K\u001a\u00020CH\u0016J\u0010\u0010L\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0019J\b\u0010M\u001a\u00020-H\u0016J\u0010\u0010N\u001a\u00020-2\u0006\u00103\u001a\u00020\u0010H\u0002J\u0010\u0010O\u001a\u00020-2\b\u0010P\u001a\u0004\u0018\u00010QJ\u000e\u0010O\u001a\u00020-2\u0006\u0010R\u001a\u00020\u0007J\u0010\u0010S\u001a\u00020-2\b\b\u0001\u0010T\u001a\u00020\u0007J\u000e\u0010U\u001a\u00020-2\u0006\u0010V\u001a\u00020\fJ\u001a\u0010W\u001a\u00020-2\b\u00102\u001a\u0004\u0018\u00010\u00152\b\u00103\u001a\u0004\u0018\u00010\u0010J\u000e\u0010X\u001a\u00020-2\u0006\u0010Y\u001a\u00020\u001bJ\u0010\u0010Z\u001a\u00020-2\b\b\u0001\u0010[\u001a\u00020\u001bJ\u0018\u0010\\\u001a\u00020-2\b\u0010]\u001a\u0004\u0018\u00010\"2\u0006\u0010^\u001a\u00020\u0007J\u0016\u0010\\\u001a\u00020-2\u0006\u0010_\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\u0007J\u0010\u0010`\u001a\u00020-2\b\b\u0001\u0010a\u001a\u00020\u001bJ\u001a\u0010b\u001a\u00020-2\u0006\u0010R\u001a\u00020\u00072\b\u0010P\u001a\u0004\u0018\u00010QH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010)\u001a\u0004\u0018\u00010(2\b\u0010'\u001a\u0004\u0018\u00010(@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006h"}, d2={"Lio/quee/fragmentation/SwipeBackLayout;", "Landroid/widget/FrameLayout;", "mContext", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mActivity", "Landroidx/fragment/app/FragmentActivity;", "mCallOnDestroyView", "", "mContentLeft", "mContentTop", "mContentView", "Landroid/view/View;", "mCurrentSwipeOrientation", "mEdgeFlag", "mEnable", "mFragment", "Lio/quee/fragmentation/core/ISupportFragment;", "mInLayout", "mListeners", "", "Lio/quee/fragmentation/SwipeBackLayout$OnSwipeListener;", "mParallaxOffset", "", "mPreFragment", "Landroidx/fragment/app/Fragment;", "mScrimOpacity", "mScrollFinishThreshold", "mScrollPercent", "mShadowLeft", "Landroid/graphics/drawable/Drawable;", "mShadowRight", "mSwipeAlpha", "mTmpRect", "Landroid/graphics/Rect;", "<set-?>", "Landroidx/customview/widget/ViewDragHelper;", "viewDragHelper", "getViewDragHelper", "()Landroidx/customview/widget/ViewDragHelper;", "addSwipeListener", "", "listener", "attachToActivity", "activity", "attachToFragment", "fragment", "view", "computeScroll", "drawChild", "canvas", "Landroid/graphics/Canvas;", "child", "drawingTime", "", "drawScrim", "drawShadow", "hiddenFragment", "init", "internalCallOnDestroyView", "onDragFinished", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onLayout", "changed", "left", "top", "right", "bottom", "onTouchEvent", "event", "removeSwipeListener", "requestLayout", "setContentView", "setEdgeLevel", "edgeLevel", "Lio/quee/fragmentation/SwipeBackLayout$EdgeLevel;", "widthPixel", "setEdgeOrientation", "orientation", "setEnableGesture", "enable", "setFragment", "setParallaxOffset", "offset", "setScrollThresHold", "threshold", "setShadow", "shadow", "edgeFlag", "resId", "setSwipeAlpha", "alpha", "validateEdgeLevel", "Companion", "EdgeLevel", "EdgeOrientation", "OnSwipeListener", "ViewDragCallback", "fragmentation-swipeback_release"})
public final class SwipeBackLayout
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context mContext;
    private float mScrollFinishThreshold;
    @Nullable
    private ViewDragHelper viewDragHelper;
    private float mScrollPercent;
    private float mScrimOpacity;
    @Nullable
    private FragmentActivity mActivity;
    @Nullable
    private View mContentView;
    @Nullable
    private ISupportFragment mFragment;
    @Nullable
    private Fragment mPreFragment;
    @Nullable
    private Drawable mShadowLeft;
    @Nullable
    private Drawable mShadowRight;
    @NotNull
    private final Rect mTmpRect;
    private int mEdgeFlag;
    private boolean mEnable;
    private int mCurrentSwipeOrientation;
    private float mParallaxOffset;
    private boolean mCallOnDestroyView;
    private boolean mInLayout;
    private int mContentLeft;
    private int mContentTop;
    private float mSwipeAlpha;
    @Nullable
    private List<OnSwipeListener> mListeners;
    public static final int EDGE_LEFT = 1;
    public static final int EDGE_RIGHT = 2;
    public static final int EDGE_ALL = 3;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_FINISHED = 3;
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final float DEFAULT_PARALLAX = 0.33f;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.4f;
    private static final int OVERSCROLL_DISTANCE = 10;

    @JvmOverloads
    public SwipeBackLayout(@Nullable Context mContext, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNull((Object)mContext);
        super(mContext, attrs, defStyleAttr);
        this.mContext = mContext;
        this.mScrollFinishThreshold = 0.4f;
        this.mTmpRect = new Rect();
        this.mEnable = true;
        this.mParallaxOffset = 0.33f;
        this.mSwipeAlpha = 0.5f;
        this.init();
    }

    public /* synthetic */ SwipeBackLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final ViewDragHelper getViewDragHelper() {
        return this.viewDragHelper;
    }

    private final void init() {
        this.viewDragHelper = ViewDragHelper.create((ViewGroup)((ViewGroup)this), (ViewDragHelper.Callback)new ViewDragCallback());
        this.setShadow(R.drawable.shadow_left, 1);
        this.setEdgeOrientation(1);
    }

    public final void setSwipeAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        this.mSwipeAlpha = alpha;
    }

    public final void setScrollThresHold(@FloatRange(from=0.0, to=1.0) float threshold) {
        boolean bl = !(threshold >= 1.0f) && !(threshold <= 0.0f);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Threshold value should be between 0 and 1.0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.mScrollFinishThreshold = threshold;
    }

    public final void setParallaxOffset(float offset) {
        this.mParallaxOffset = offset;
    }

    public final void setEdgeOrientation(@EdgeOrientation int orientation) {
        this.mEdgeFlag = orientation;
        ViewDragHelper viewDragHelper = this.viewDragHelper;
        Intrinsics.checkNotNull((Object)viewDragHelper);
        viewDragHelper.setEdgeTrackingEnabled(orientation);
        if (orientation == 2 || orientation == 3) {
            this.setShadow(R.drawable.shadow_right, 2);
        }
    }

    public final void setShadow(@Nullable Drawable shadow, int edgeFlag) {
        if ((edgeFlag & 1) != 0) {
            this.mShadowLeft = shadow;
        } else if ((edgeFlag & 2) != 0) {
            this.mShadowRight = shadow;
        }
        this.invalidate();
    }

    public final void setShadow(int resId, int edgeFlag) {
        this.setShadow(this.getResources().getDrawable(resId), edgeFlag);
    }

    public final void addSwipeListener(@NotNull OnSwipeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        List<OnSwipeListener> list = this.mListeners;
        Intrinsics.checkNotNull(list);
        list.add(listener);
    }

    public final void removeSwipeListener(@Nullable OnSwipeListener listener) {
        if (this.mListeners == null) {
            return;
        }
        Collection<OnSwipeListener> collection = this.mListeners;
        Intrinsics.checkNotNull(collection);
        collection = collection;
        boolean bl = false;
        TypeIntrinsics.asMutableCollection(collection).remove(listener);
    }

    protected boolean drawChild(@NotNull Canvas canvas, @NotNull View child, long drawingTime) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean isDrawView = child == this.mContentView;
        boolean drawChild = super.drawChild(canvas, child, drawingTime);
        if (isDrawView && this.mScrimOpacity > 0.0f) {
            ViewDragHelper viewDragHelper = this.viewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.getViewDragState() != 0) {
                this.drawShadow(canvas, child);
                this.drawScrim(canvas, child);
            }
        }
        return drawChild;
    }

    private final void drawShadow(Canvas canvas, View child) {
        Rect childRect = this.mTmpRect;
        child.getHitRect(childRect);
        if ((this.mCurrentSwipeOrientation & 1) != 0) {
            Drawable drawable2 = this.mShadowLeft;
            Intrinsics.checkNotNull((Object)drawable2);
            Drawable drawable3 = drawable2;
            int n = childRect.left;
            drawable2 = this.mShadowLeft;
            Intrinsics.checkNotNull((Object)drawable2);
            drawable3.setBounds(n - drawable2.getIntrinsicWidth(), childRect.top, childRect.left, childRect.bottom);
            drawable2 = this.mShadowLeft;
            Intrinsics.checkNotNull((Object)drawable2);
            drawable2.setAlpha((int)(this.mScrimOpacity * (float)255));
            drawable2 = this.mShadowLeft;
            Intrinsics.checkNotNull((Object)drawable2);
            drawable2.draw(canvas);
        } else if ((this.mCurrentSwipeOrientation & 2) != 0) {
            Drawable drawable4 = this.mShadowRight;
            Intrinsics.checkNotNull((Object)drawable4);
            Drawable drawable5 = drawable4;
            int n = childRect.right;
            int n2 = childRect.top;
            int n3 = childRect.right;
            drawable4 = this.mShadowRight;
            Intrinsics.checkNotNull((Object)drawable4);
            drawable5.setBounds(n, n2, n3 + drawable4.getIntrinsicWidth(), childRect.bottom);
            drawable4 = this.mShadowRight;
            Intrinsics.checkNotNull((Object)drawable4);
            drawable4.setAlpha((int)(this.mScrimOpacity * (float)255));
            drawable4 = this.mShadowRight;
            Intrinsics.checkNotNull((Object)drawable4);
            drawable4.draw(canvas);
        }
    }

    private final void drawScrim(Canvas canvas, View child) {
        int baseAlpha = 153;
        int alpha = (int)((float)baseAlpha * this.mScrimOpacity * this.mSwipeAlpha);
        int color = alpha << 24;
        if ((this.mCurrentSwipeOrientation & 1) != 0) {
            canvas.clipRect(0, 0, child.getLeft(), this.getHeight());
        } else if ((this.mCurrentSwipeOrientation & 2) != 0) {
            canvas.clipRect(child.getRight(), 0, this.getRight(), this.getHeight());
        }
        canvas.drawColor(color);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        if (this.mContentView != null) {
            View view = this.mContentView;
            Intrinsics.checkNotNull((Object)view);
            View view2 = view;
            view = this.mContentView;
            Intrinsics.checkNotNull((Object)view);
            int n = this.mContentLeft + view.getMeasuredWidth();
            view = this.mContentView;
            Intrinsics.checkNotNull((Object)view);
            view2.layout(this.mContentLeft, this.mContentTop, n, this.mContentTop + view.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        this.mScrimOpacity = 1.0f - this.mScrollPercent;
        if (this.mScrimOpacity >= 0.0f) {
            ViewDragHelper viewDragHelper = this.viewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            if (viewDragHelper.continueSettling(true)) {
                ViewCompat.postInvalidateOnAnimation((View)((View)this));
            }
            if (this.mPreFragment != null) {
                viewDragHelper = this.mPreFragment;
                Intrinsics.checkNotNull((Object)viewDragHelper);
                if (viewDragHelper.getView() != null) {
                    if (this.mCallOnDestroyView) {
                        Fragment fragment = this.mPreFragment;
                        Intrinsics.checkNotNull((Object)fragment);
                        viewDragHelper = fragment.getView();
                        Intrinsics.checkNotNull((Object)viewDragHelper);
                        viewDragHelper.setX(0.0f);
                        return;
                    }
                    viewDragHelper = this.viewDragHelper;
                    Intrinsics.checkNotNull((Object)viewDragHelper);
                    if (viewDragHelper.getCapturedView() != null) {
                        ViewDragHelper viewDragHelper2 = this.viewDragHelper;
                        Intrinsics.checkNotNull((Object)viewDragHelper2);
                        View view = viewDragHelper2.getCapturedView();
                        Intrinsics.checkNotNull((Object)view);
                        int leftOffset = (int)((float)(view.getLeft() - this.getWidth()) * this.mParallaxOffset * this.mScrimOpacity);
                        viewDragHelper2 = this.mPreFragment;
                        Intrinsics.checkNotNull((Object)viewDragHelper2);
                        view = viewDragHelper2.getView();
                        Intrinsics.checkNotNull((Object)view);
                        view.setX(leftOffset > 0 ? 0.0f : (float)leftOffset);
                    }
                }
            }
        }
    }

    public final void internalCallOnDestroyView() {
        this.mCallOnDestroyView = true;
    }

    public final void setFragment(@Nullable ISupportFragment fragment, @Nullable View view) {
        this.mFragment = fragment;
        this.mContentView = view;
    }

    public final void hiddenFragment() {
        if (this.mPreFragment != null) {
            Fragment fragment = this.mPreFragment;
            Intrinsics.checkNotNull((Object)fragment);
            if (fragment.getView() != null) {
                Fragment fragment2 = this.mPreFragment;
                Intrinsics.checkNotNull((Object)fragment2);
                fragment = fragment2.getView();
                Intrinsics.checkNotNull((Object)fragment);
                fragment.setVisibility(8);
            }
        }
    }

    public final void attachToActivity(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.mActivity = activity;
        int[] nArray = new int[]{16842836};
        TypedArray typedArray = activity.getTheme().obtainStyledAttributes(nArray);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"activity.theme.obtainStyledAttributes(\n            intArrayOf(\n                android.R.attr.windowBackground\n            )\n        )");
        TypedArray a = typedArray;
        int background = a.getResourceId(0, 0);
        a.recycle();
        ViewGroup decor = (ViewGroup)activity.getWindow().getDecorView();
        View view = decor.getChildAt(0);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup decorChild = (ViewGroup)view;
        decorChild.setBackgroundResource(background);
        decor.removeView((View)decorChild);
        this.addView((View)decorChild);
        this.setContentView((View)decorChild);
        decor.addView((View)this);
    }

    public final void attachToFragment(@Nullable ISupportFragment fragment, @Nullable View view) {
        this.addView(view);
        this.setFragment(fragment, view);
    }

    private final void setContentView(View view) {
        this.mContentView = view;
    }

    public final void setEnableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public final void setEdgeLevel(@Nullable EdgeLevel edgeLevel) {
        this.validateEdgeLevel(-1, edgeLevel);
    }

    public final void setEdgeLevel(int widthPixel) {
        this.validateEdgeLevel(widthPixel, null);
    }

    private final void validateEdgeLevel(int widthPixel, EdgeLevel edgeLevel) {
        try {
            Class<?> clazz;
            DisplayMetrics metrics = new DisplayMetrics();
            Object object = this.mContext;
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object.getSystemService("window");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object2;
            windowManager.getDefaultDisplay().getMetrics(metrics);
            object = this.viewDragHelper;
            Field mEdgeSize = object == null ? null : ((clazz = object.getClass()) == null ? null : clazz.getDeclaredField("mEdgeSize"));
            object = mEdgeSize;
            if (object != null) {
                ((Field)object).setAccessible(true);
            }
            if (widthPixel >= 0) {
                object = mEdgeSize;
                if (object != null) {
                    ((Field)object).setInt(this.viewDragHelper, widthPixel);
                }
            } else if (edgeLevel == EdgeLevel.MAX) {
                object = mEdgeSize;
                if (object != null) {
                    ((Field)object).setInt(this.viewDragHelper, metrics.widthPixels);
                }
            } else if (edgeLevel == EdgeLevel.MED) {
                object = mEdgeSize;
                if (object != null) {
                    ((Field)object).setInt(this.viewDragHelper, metrics.widthPixels / 2);
                }
            } else {
                object = mEdgeSize;
                if (object != null) {
                    ((Field)object).setInt(this.viewDragHelper, (int)((float)20 * metrics.density + 0.5f));
                }
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private final void onDragFinished() {
        if (this.mListeners != null) {
            List<OnSwipeListener> list = this.mListeners;
            Intrinsics.checkNotNull(list);
            for (OnSwipeListener listener : list) {
                listener.onDragStateChange(3);
            }
        }
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        if (!this.mEnable) {
            return super.onInterceptTouchEvent(ev);
        }
        try {
            ViewDragHelper viewDragHelper = this.viewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            return viewDragHelper.shouldInterceptTouchEvent(ev);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.mEnable) {
            return super.onTouchEvent(event);
        }
        try {
            ViewDragHelper viewDragHelper = this.viewDragHelper;
            Intrinsics.checkNotNull((Object)viewDragHelper);
            viewDragHelper.processTouchEvent(event);
            return true;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    @JvmOverloads
    public SwipeBackLayout(@Nullable Context mContext, @Nullable AttributeSet attrs) {
        this(mContext, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SwipeBackLayout(@Nullable Context mContext) {
        this(mContext, null, 0, 6, null);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lio/quee/fragmentation/SwipeBackLayout$EdgeOrientation;", "", "fragmentation-swipeback_release"})
    public static @interface EdgeOrientation {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/quee/fragmentation/SwipeBackLayout$EdgeLevel;", "", "(Ljava/lang/String;I)V", "MAX", "MIN", "MED", "fragmentation-swipeback_release"})
    public static final class EdgeLevel
    extends Enum<EdgeLevel> {
        public static final /* enum */ EdgeLevel MAX = new EdgeLevel();
        public static final /* enum */ EdgeLevel MIN = new EdgeLevel();
        public static final /* enum */ EdgeLevel MED = new EdgeLevel();
        private static final /* synthetic */ EdgeLevel[] $VALUES;

        public static EdgeLevel[] values() {
            EdgeLevel[] edgeLevelArray = $VALUES;
            return Arrays.copyOf(edgeLevelArray, edgeLevelArray.length);
        }

        public static EdgeLevel valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(EdgeLevel.class, value);
        }

        static {
            $VALUES = edgeLevelArray = new EdgeLevel[]{EdgeLevel.MAX, EdgeLevel.MIN, EdgeLevel.MED};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\bH&\u00a8\u0006\u000b"}, d2={"Lio/quee/fragmentation/SwipeBackLayout$OnSwipeListener;", "", "onDragScrolled", "", "scrollPercent", "", "onDragStateChange", "state", "", "onEdgeTouch", "oritentationEdgeFlag", "fragmentation-swipeback_release"})
    public static interface OnSwipeListener {
        public void onDragStateChange(int var1);

        public void onEdgeTouch(int var1);

        public void onDragScrolled(float var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J0\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u001b"}, d2={"Lio/quee/fragmentation/SwipeBackLayout$ViewDragCallback;", "Landroidx/customview/widget/ViewDragHelper$Callback;", "(Lio/quee/fragmentation/SwipeBackLayout;)V", "clampViewPositionHorizontal", "", "child", "Landroid/view/View;", "left", "dx", "getViewHorizontalDragRange", "onEdgeTouched", "", "edgeFlags", "pointerId", "onViewDragStateChanged", "state", "onViewPositionChanged", "changedView", "top", "dy", "onViewReleased", "releasedChild", "xvel", "", "yvel", "tryCaptureView", "", "fragmentation-swipeback_release"})
    private final class ViewDragCallback
    extends ViewDragHelper.Callback {
        public ViewDragCallback() {
            Intrinsics.checkNotNullParameter((Object)((Object)SwipeBackLayout.this), (String)"this$0");
        }

        public boolean tryCaptureView(@NotNull View child, int pointerId) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            Object object = SwipeBackLayout.this.getViewDragHelper();
            Intrinsics.checkNotNull((Object)object);
            boolean dragEnable = object.isEdgeTouched(SwipeBackLayout.this.mEdgeFlag, pointerId);
            if (dragEnable) {
                List list;
                object = SwipeBackLayout.this.getViewDragHelper();
                Intrinsics.checkNotNull((Object)object);
                if (object.isEdgeTouched(1, pointerId)) {
                    SwipeBackLayout.this.mCurrentSwipeOrientation = 1;
                } else {
                    object = SwipeBackLayout.this.getViewDragHelper();
                    Intrinsics.checkNotNull((Object)object);
                    if (object.isEdgeTouched(2, pointerId)) {
                        SwipeBackLayout.this.mCurrentSwipeOrientation = 2;
                    }
                }
                if (SwipeBackLayout.this.mListeners != null) {
                    list = SwipeBackLayout.this.mListeners;
                    Intrinsics.checkNotNull((Object)list);
                    for (OnSwipeListener listener : list) {
                        listener.onEdgeTouch(SwipeBackLayout.this.mCurrentSwipeOrientation);
                    }
                }
                if (SwipeBackLayout.this.mPreFragment == null) {
                    if (SwipeBackLayout.this.mFragment != null) {
                        int index;
                        int n;
                        OnSwipeListener listener;
                        ISupportFragment iSupportFragment = SwipeBackLayout.this.mFragment;
                        if (iSupportFragment == null) {
                            throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.Fragment");
                        }
                        FragmentManager fragmentManager = ((Fragment)iSupportFragment).getFragmentManager();
                        Intrinsics.checkNotNull((Object)fragmentManager);
                        listener = fragmentManager;
                        List fragmentList = FragmentationMagician.INSTANCE.getActiveFragments((FragmentManager)listener);
                        if (fragmentList.size() > 1 && 0 <= (n = (index = fragmentList.indexOf((Fragment)SwipeBackLayout.this.mFragment)) - 1)) {
                            do {
                                int i;
                                Fragment fragment;
                                if ((fragment = (Fragment)fragmentList.get(i = n--)) == null || fragment.getView() == null) continue;
                                View view = fragment.getView();
                                Intrinsics.checkNotNull((Object)view);
                                view.setVisibility(0);
                                SwipeBackLayout.this.mPreFragment = fragment;
                                break;
                            } while (0 <= n);
                        }
                    }
                } else {
                    list = SwipeBackLayout.this.mPreFragment;
                    Intrinsics.checkNotNull((Object)list);
                    View preView = list.getView();
                    if (preView != null && preView.getVisibility() != 0) {
                        preView.setVisibility(0);
                    }
                }
            }
            return dragEnable;
        }

        public int clampViewPositionHorizontal(@NotNull View child, int left, int dx) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            int ret = 0;
            if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            } else if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 2) != 0) {
                ret = Math.min(0, Math.max(left, -child.getWidth()));
            }
            return ret;
        }

        public void onViewPositionChanged(@NotNull View changedView, int left, int top, int dx, int dy) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)changedView, (String)"changedView");
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 1) != 0) {
                float f = left;
                object = SwipeBackLayout.this.mContentView;
                Intrinsics.checkNotNull((Object)object);
                int n = object.getWidth();
                object = SwipeBackLayout.this.mShadowLeft;
                Intrinsics.checkNotNull((Object)object);
                SwipeBackLayout.this.mScrollPercent = Math.abs(f / (float)(n + object.getIntrinsicWidth()));
            } else if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 2) != 0) {
                float f = left;
                object = SwipeBackLayout.this.mContentView;
                Intrinsics.checkNotNull((Object)object);
                int n = object.getWidth();
                object = SwipeBackLayout.this.mShadowRight;
                Intrinsics.checkNotNull((Object)object);
                SwipeBackLayout.this.mScrollPercent = Math.abs(f / (float)(n + object.getIntrinsicWidth()));
            }
            SwipeBackLayout.this.mContentLeft = left;
            SwipeBackLayout.this.mContentTop = top;
            SwipeBackLayout.this.invalidate();
            if (SwipeBackLayout.this.mListeners != null) {
                object = SwipeBackLayout.this.getViewDragHelper();
                Intrinsics.checkNotNull((Object)object);
                if (object.getViewDragState() == 1 && SwipeBackLayout.this.mScrollPercent <= 1.0f && SwipeBackLayout.this.mScrollPercent > 0.0f) {
                    List list = SwipeBackLayout.this.mListeners;
                    Intrinsics.checkNotNull((Object)list);
                    for (OnSwipeListener listener : list) {
                        listener.onDragScrolled(SwipeBackLayout.this.mScrollPercent);
                    }
                }
            }
            if (SwipeBackLayout.this.mScrollPercent > 1.0f) {
                if (SwipeBackLayout.this.mFragment != null) {
                    if (SwipeBackLayout.this.mCallOnDestroyView) {
                        return;
                    }
                    object = SwipeBackLayout.this.mFragment;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type androidx.fragment.app.Fragment");
                    }
                    if (!((Fragment)object).isDetached()) {
                        SwipeBackLayout.this.onDragFinished();
                        object = SwipeBackLayout.this.mFragment;
                        Intrinsics.checkNotNull((Object)object);
                        object.getSupportDelegate().popQuiet();
                    }
                } else {
                    object = SwipeBackLayout.this.mActivity;
                    Intrinsics.checkNotNull((Object)object);
                    if (!object.isFinishing()) {
                        SwipeBackLayout.this.onDragFinished();
                        object = SwipeBackLayout.this.mActivity;
                        Intrinsics.checkNotNull((Object)object);
                        object.finish();
                        object = SwipeBackLayout.this.mActivity;
                        Intrinsics.checkNotNull((Object)object);
                        object.overridePendingTransition(0, 0);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getViewHorizontalDragRange(@NotNull View child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (SwipeBackLayout.this.mFragment != null) {
                return 1;
            }
            if (!(SwipeBackLayout.this.mActivity instanceof ISwipeBackActivity)) return 0;
            FragmentActivity fragmentActivity = SwipeBackLayout.this.mActivity;
            if (fragmentActivity == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.quee.fragmentation.swipeback.core.ISwipeBackActivity");
            }
            if (!((ISwipeBackActivity)fragmentActivity).swipeBackPriority()) return 0;
            return 1;
        }

        public void onViewReleased(@NotNull View releasedChild, float xvel, float yvel) {
            Drawable drawable;
            Intrinsics.checkNotNullParameter((Object)releasedChild, (String)"releasedChild");
            int childWidth = releasedChild.getWidth();
            int left = 0;
            int top = 0;
            if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 1) != 0) {
                int n;
                if (xvel > 0.0f || xvel == 0.0f && SwipeBackLayout.this.mScrollPercent > SwipeBackLayout.this.mScrollFinishThreshold) {
                    drawable = SwipeBackLayout.this.mShadowLeft;
                    Intrinsics.checkNotNull((Object)drawable);
                    n = childWidth + drawable.getIntrinsicWidth() + 10;
                } else {
                    n = 0;
                }
                left = n;
            } else if ((SwipeBackLayout.this.mCurrentSwipeOrientation & 2) != 0) {
                int n;
                if (xvel < 0.0f || xvel == 0.0f && SwipeBackLayout.this.mScrollPercent > SwipeBackLayout.this.mScrollFinishThreshold) {
                    drawable = SwipeBackLayout.this.mShadowRight;
                    Intrinsics.checkNotNull((Object)drawable);
                    n = -(childWidth + drawable.getIntrinsicWidth() + 10);
                } else {
                    n = 0;
                }
                left = n;
            }
            drawable = SwipeBackLayout.this.getViewDragHelper();
            Intrinsics.checkNotNull((Object)drawable);
            drawable.settleCapturedViewAt(left, top);
            SwipeBackLayout.this.invalidate();
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (SwipeBackLayout.this.mListeners != null) {
                List list = SwipeBackLayout.this.mListeners;
                Intrinsics.checkNotNull((Object)list);
                for (OnSwipeListener listener : list) {
                    listener.onDragStateChange(state);
                }
            }
        }

        public void onEdgeTouched(int edgeFlags, int pointerId) {
            super.onEdgeTouched(edgeFlags, pointerId);
            if ((SwipeBackLayout.this.mEdgeFlag & edgeFlags) != 0) {
                SwipeBackLayout.this.mCurrentSwipeOrientation = edgeFlags;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/quee/fragmentation/SwipeBackLayout$Companion;", "", "()V", "DEFAULT_PARALLAX", "", "DEFAULT_SCRIM_COLOR", "", "DEFAULT_SCROLL_THRESHOLD", "EDGE_ALL", "EDGE_LEFT", "EDGE_RIGHT", "FULL_ALPHA", "OVERSCROLL_DISTANCE", "STATE_DRAGGING", "STATE_FINISHED", "STATE_IDLE", "STATE_SETTLING", "fragmentation-swipeback_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

