/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.swipeback.core;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentActivity;
import io.quee.fragmentation.SwipeBackLayout;
import io.quee.fragmentation.core.ISupportActivity;
import io.quee.fragmentation.swipeback.core.ISwipeBackActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lio/quee/fragmentation/swipeback/core/SwipeBackActivityDelegate;", "", "swipeBackActivity", "Lio/quee/fragmentation/swipeback/core/ISwipeBackActivity;", "(Lio/quee/fragmentation/swipeback/core/ISwipeBackActivity;)V", "mActivity", "Landroidx/fragment/app/FragmentActivity;", "<set-?>", "Lio/quee/fragmentation/SwipeBackLayout;", "swipeBackLayout", "getSwipeBackLayout", "()Lio/quee/fragmentation/SwipeBackLayout;", "onActivityCreate", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onPostCreate", "setEdgeLevel", "edgeLevel", "Lio/quee/fragmentation/SwipeBackLayout$EdgeLevel;", "widthPixel", "", "setSwipeBackEnable", "enable", "", "swipeBackPriority", "fragmentation-swipeback_release"})
public final class SwipeBackActivityDelegate {
    @NotNull
    private final FragmentActivity mActivity;
    @Nullable
    private SwipeBackLayout swipeBackLayout;

    public SwipeBackActivityDelegate(@Nullable ISwipeBackActivity swipeBackActivity) {
        if (!(swipeBackActivity instanceof FragmentActivity) || !(swipeBackActivity instanceof ISupportActivity)) {
            throw new RuntimeException("Must extends FragmentActivity/AppCompatActivity and implements ISupportActivity");
        }
        this.mActivity = (FragmentActivity)swipeBackActivity;
    }

    @Nullable
    public final SwipeBackLayout getSwipeBackLayout() {
        return this.swipeBackLayout;
    }

    public final void onCreate(@Nullable Bundle savedInstanceState) {
        this.onActivityCreate();
    }

    public final void onPostCreate(@Nullable Bundle savedInstanceState) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.attachToActivity(this.mActivity);
    }

    public final void setSwipeBackEnable(boolean enable) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setEnableGesture(enable);
    }

    public final void setEdgeLevel(@Nullable SwipeBackLayout.EdgeLevel edgeLevel) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setEdgeLevel(edgeLevel);
    }

    public final void setEdgeLevel(int widthPixel) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setEdgeLevel(widthPixel);
    }

    public final boolean swipeBackPriority() {
        return this.mActivity.getSupportFragmentManager().getBackStackEntryCount() <= 1;
    }

    private final void onActivityCreate() {
        this.mActivity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mActivity.getWindow().getDecorView().setBackgroundColor(0);
        this.swipeBackLayout = new SwipeBackLayout((Context)this.mActivity, null, 0, 6, null);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setLayoutParams(params);
    }
}

