/*
 * Decompiled with CFR 0.152.
 */
package io.quee.fragmentation.swipeback.core;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.fragment.app.Fragment;
import io.quee.fragmentation.SwipeBackLayout;
import io.quee.fragmentation.core.ISupportFragment;
import io.quee.fragmentation.core.SupportFragmentDelegate;
import io.quee.fragmentation.swipeback.core.ISwipeBackFragment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00122\b\b\u0001\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lio/quee/fragmentation/swipeback/core/SwipeBackFragmentDelegate;", "", "swipeBackFragment", "Lio/quee/fragmentation/swipeback/core/ISwipeBackFragment;", "(Lio/quee/fragmentation/swipeback/core/ISwipeBackFragment;)V", "mFragment", "Landroidx/fragment/app/Fragment;", "mSupport", "Lio/quee/fragmentation/core/ISupportFragment;", "<set-?>", "Lio/quee/fragmentation/SwipeBackLayout;", "swipeBackLayout", "getSwipeBackLayout", "()Lio/quee/fragmentation/SwipeBackLayout;", "attachToSwipeBack", "Landroid/view/View;", "view", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "onFragmentCreate", "onHiddenChanged", "hidden", "", "onViewCreated", "setEdgeLevel", "edgeLevel", "Lio/quee/fragmentation/SwipeBackLayout$EdgeLevel;", "widthPixel", "", "setParallaxOffset", "offset", "", "setSwipeBackEnable", "enable", "fragmentation-swipeback_release"})
public final class SwipeBackFragmentDelegate {
    @NotNull
    private final Fragment mFragment;
    @NotNull
    private final ISupportFragment mSupport;
    @Nullable
    private SwipeBackLayout swipeBackLayout;

    public SwipeBackFragmentDelegate(@Nullable ISwipeBackFragment swipeBackFragment) {
        if (!(swipeBackFragment instanceof Fragment) || !(swipeBackFragment instanceof ISupportFragment)) {
            throw new RuntimeException("Must extends Fragment and implements ISupportFragment!");
        }
        this.mFragment = (Fragment)swipeBackFragment;
        this.mSupport = (ISupportFragment)swipeBackFragment;
    }

    @Nullable
    public final SwipeBackLayout getSwipeBackLayout() {
        return this.swipeBackLayout;
    }

    public final void onCreate(@Nullable Bundle savedInstanceState) {
        this.onFragmentCreate();
    }

    public final void onViewCreated(@Nullable View view, @Nullable Bundle savedInstanceState) {
        if (view instanceof SwipeBackLayout) {
            View childView = ((SwipeBackLayout)view).getChildAt(0);
            SupportFragmentDelegate supportFragmentDelegate = this.mSupport.getSupportDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)childView, (String)"childView");
            supportFragmentDelegate.setBackground(childView);
        } else {
            SupportFragmentDelegate supportFragmentDelegate = this.mSupport.getSupportDelegate();
            Intrinsics.checkNotNull((Object)view);
            supportFragmentDelegate.setBackground(view);
        }
    }

    @Nullable
    public final View attachToSwipeBack(@Nullable View view) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.attachToFragment(this.mSupport, view);
        return (View)this.swipeBackLayout;
    }

    public final void setEdgeLevel(@Nullable SwipeBackLayout.EdgeLevel edgeLevel) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setEdgeLevel(edgeLevel);
    }

    public final void setEdgeLevel(int widthPixel) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setEdgeLevel(widthPixel);
    }

    public final void onHiddenChanged(boolean hidden) {
        if (hidden && this.swipeBackLayout != null) {
            SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
            Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
            swipeBackLayout.hiddenFragment();
        }
    }

    public final void setSwipeBackEnable(boolean enable) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setEnableGesture(enable);
    }

    public final void setParallaxOffset(@FloatRange(from=0.0, to=1.0) float offset) {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setParallaxOffset(offset);
    }

    public final void onDestroyView() {
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.internalCallOnDestroyView();
    }

    private final void onFragmentCreate() {
        if (this.mFragment.getContext() == null) {
            return;
        }
        this.swipeBackLayout = new SwipeBackLayout(this.mFragment.getContext(), null, 0, 6, null);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        SwipeBackLayout swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setLayoutParams(params);
        swipeBackLayout = this.swipeBackLayout;
        Intrinsics.checkNotNull((Object)((Object)swipeBackLayout));
        swipeBackLayout.setBackgroundColor(0);
    }
}

