/*-
 * #%L
 * Kafka Encryption
 * %%
 * Copyright (C) 2018 Quicksign
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package io.quicksign.kafka.crypto.encryption;

import java.util.Optional;

/**
 * A keyprovider has to provide the key associated to a keyref
 *
 * @see DefaultEncryptor
 * @see DefaultDecryptor
 */
public interface KeyProvider {

    /**
     * @param keyRef the reference of the key to retrieve
     * @return the actual key or {@code Optional.empty()} if the key cannot not be found
     */
    Optional<byte[]> getKey(byte[] keyRef);
}
