/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto;

import io.quicksign.kafka.crypto.Decryptor;
import io.quicksign.kafka.crypto.KafkaCryptoConstants;
import io.quicksign.kafka.crypto.utils.ArrayUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoDeserializer<T>
implements ExtendedDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(CryptoDeserializer.class);
    private final ExtendedDeserializer<? extends T> rawDeserializer;
    private final Decryptor decryptor;

    public CryptoDeserializer(ExtendedDeserializer<? extends T> rawDeserializer, Decryptor decryptor) {
        this.rawDeserializer = rawDeserializer;
        this.decryptor = decryptor;
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        DecryptedDataWithKeyRef decryptedDataWithKeyRef = this.decrypt(data);
        Object deserializedValue = this.rawDeserializer.deserialize(topic, headers, decryptedDataWithKeyRef.decryptedData);
        headers.add("keKeyReference", decryptedDataWithKeyRef.keyRef);
        return (T)deserializedValue;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.rawDeserializer.configure(configs, isKey);
    }

    public T deserialize(String topic, byte[] data) {
        return this.deserialize(topic, (Headers)new RecordHeaders(), data);
    }

    private DecryptedDataWithKeyRef decrypt(byte[] data) {
        if (ArrayUtils.startWith(data, KafkaCryptoConstants.ENCRYPTED_PREFIX)) {
            byte[] decryptedData;
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, KafkaCryptoConstants.ENCRYPTED_PREFIX.length, data.length - KafkaCryptoConstants.ENCRYPTED_PREFIX.length);
            int keyRefLength = byteBuffer.getInt();
            byte[] keyRef = null;
            if (keyRefLength == 0) {
                log.debug("not key ref, data are not encrypted");
                decryptedData = new byte[byteBuffer.remaining()];
                byteBuffer.get(decryptedData);
            } else {
                keyRef = new byte[keyRefLength];
                byteBuffer.get(keyRef);
                byte[] encryptedData = new byte[byteBuffer.remaining()];
                byteBuffer.get(encryptedData);
                decryptedData = this.decryptor.decrypt(encryptedData, keyRef);
            }
            return new DecryptedDataWithKeyRef(keyRef, decryptedData);
        }
        return new DecryptedDataWithKeyRef(null, data);
    }

    public void close() {
        this.rawDeserializer.close();
    }

    private static class DecryptedDataWithKeyRef {
        private final byte[] keyRef;
        private final byte[] decryptedData;

        DecryptedDataWithKeyRef(byte[] keyRef, byte[] decryptedData) {
            this.keyRef = keyRef;
            this.decryptedData = decryptedData;
        }
    }
}

