/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto.encryption;

import io.quicksign.kafka.crypto.Encryptor;
import io.quicksign.kafka.crypto.encryption.CryptoAlgorithm;
import io.quicksign.kafka.crypto.encryption.KeyProvider;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncryptor
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultEncryptor.class);
    private final KeyProvider keyProvider;
    private final CryptoAlgorithm cryptoAlgorithm;

    public DefaultEncryptor(KeyProvider keyProvider, CryptoAlgorithm cryptoAlgorithm) {
        this.keyProvider = keyProvider;
        this.cryptoAlgorithm = cryptoAlgorithm;
    }

    @Override
    public byte[] encrypt(byte[] value, byte[] keyRef) {
        Optional<byte[]> maybeKey = this.keyProvider.getKey(keyRef);
        return maybeKey.map(key -> {
            try {
                return this.cryptoAlgorithm.encrypt(value, (byte[])key);
            }
            catch (Exception e) {
                log.error("error while encrypting data", (Throwable)e);
                return null;
            }
        }).orElse(null);
    }
}

