/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto.pairing.serdes;

import io.quicksign.kafka.crypto.CryptoDeserializer;
import io.quicksign.kafka.crypto.CryptoSerializer;
import io.quicksign.kafka.crypto.Decryptor;
import io.quicksign.kafka.crypto.Encryptor;
import io.quicksign.kafka.crypto.pairing.internal.CryptoAwareSerializerWrapper;
import io.quicksign.kafka.crypto.pairing.keyextractor.KeyReferenceExtractor;
import io.quicksign.kafka.crypto.pairing.serdes.SerdeFactory;
import io.quicksign.kafka.crypto.pairing.serdes.SerdesPair;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.common.serialization.ExtendedSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class CryptoSerdeFactory
implements SerdeFactory {
    private final Encryptor encryptor;
    private final Decryptor decryptor;
    private final KeyReferenceExtractor keyReferenceExtractor;

    public CryptoSerdeFactory(Encryptor encryptor, Decryptor decryptor, KeyReferenceExtractor keyReferenceExtractor) {
        this.encryptor = encryptor;
        this.decryptor = decryptor;
        this.keyReferenceExtractor = keyReferenceExtractor;
    }

    public <T> Serde<T> buildFrom(Serde<T> rawSerde) {
        return this.buildFrom(rawSerde, null);
    }

    private <T> Serde<T> buildFrom(Serde<T> rawSerde, ThreadLocal<byte[]> keyRefHolder) {
        ExtendedDeserializer rawExtendedDeserializer = ExtendedDeserializer.Wrapper.ensureExtended((Deserializer)rawSerde.deserializer());
        ExtendedSerializer rawExtendedSerializer = ExtendedSerializer.Wrapper.ensureExtended((Serializer)rawSerde.serializer());
        return Serdes.serdeFrom(new CryptoSerializer(rawExtendedSerializer, this.encryptor, keyRefHolder), new CryptoDeserializer(rawExtendedDeserializer, this.decryptor));
    }

    @Override
    public <K, V> SerdesPair<K, V> buildSerdesPair(Serde<K> keySerde, Serde<V> valueSerde) {
        ThreadLocal<byte[]> keyRefHolder = new ThreadLocal<byte[]>();
        Serde newKeySerde = Serdes.serdeFrom(new CryptoAwareSerializerWrapper(keySerde.serializer(), this.keyReferenceExtractor, keyRefHolder), (Deserializer)keySerde.deserializer());
        Serde<V> newValueSerde = this.buildFrom(valueSerde, keyRefHolder);
        return new SerdesPair(newKeySerde, newValueSerde);
    }

    @Override
    public <V> Serde<V> buildSelfCryptoAwareSerde(Serde<V> valueSerde) {
        ThreadLocal<byte[]> keyRefHolder = new ThreadLocal<byte[]>();
        Serde<V> cryptoSerde = this.buildFrom(valueSerde, keyRefHolder);
        Serde selfAwareSerde = Serdes.serdeFrom(new CryptoAwareSerializerWrapper(cryptoSerde.serializer(), this.keyReferenceExtractor, keyRefHolder), (Deserializer)cryptoSerde.deserializer());
        return selfAwareSerde;
    }
}

