/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto;

import io.quicksign.kafka.crypto.Encryptor;
import io.quicksign.kafka.crypto.KafkaCryptoConstants;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoSerializer<T>
implements Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(CryptoSerializer.class);
    private final Serializer<? super T> rawSerializer;
    private final Encryptor encryptor;
    private final ThreadLocal<byte[]> keyRefHolder;

    public CryptoSerializer(Serializer<? super T> rawSerializer, Encryptor encryptor, ThreadLocal<byte[]> keyRefHolder) {
        this.rawSerializer = rawSerializer;
        this.encryptor = encryptor;
        this.keyRefHolder = keyRefHolder;
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        byte[] serializedData = this.rawSerializer.serialize(topic, headers, data);
        if (serializedData == null) {
            return null;
        }
        Header keyReferenceHeader = headers.lastHeader("keKeyReference");
        return this.encrypt(serializedData, keyReferenceHeader == null ? null : keyReferenceHeader.value());
    }

    public byte[] serialize(String topic, T data) {
        byte[] serializedData = this.rawSerializer.serialize(topic, data);
        if (serializedData == null) {
            return null;
        }
        return this.encrypt(serializedData, this.keyRefHolder == null ? null : this.keyRefHolder.get());
    }

    private byte[] encrypt(byte[] serializedData, byte[] keyref) {
        if (keyref == null) {
            log.debug("keyref header not defined or null, we will send data unencrypted");
            return serializedData;
        }
        byte[] encryptedData = this.encryptor.encrypt(serializedData, keyref);
        if (encryptedData == null) {
            return null;
        }
        return ByteBuffer.allocate(KafkaCryptoConstants.ENCRYPTED_PREFIX.length + 4 + keyref.length + encryptedData.length).put(KafkaCryptoConstants.ENCRYPTED_PREFIX).putInt(keyref.length).put(keyref).put(encryptedData).array();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.rawSerializer.configure(configs, isKey);
    }

    public void close() {
        this.rawSerializer.close();
    }
}

