/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto.pairing.internal;

import io.quicksign.kafka.crypto.pairing.keyextractor.KeyReferenceExtractor;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class CryptoAwareSerializerWrapper<T>
implements Serializer<T> {
    private final Serializer<T> rawSerializer;
    private final KeyReferenceExtractor keyReferenceExtractor;
    private final ThreadLocal<byte[]> keyRefHolder;

    public CryptoAwareSerializerWrapper(Serializer<T> rawSerializer, KeyReferenceExtractor keyReferenceExtractor, ThreadLocal<byte[]> keyRefHolder) {
        this.rawSerializer = rawSerializer;
        this.keyReferenceExtractor = keyReferenceExtractor;
        this.keyRefHolder = keyRefHolder;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.rawSerializer.configure(configs, isKey);
    }

    public byte[] serialize(String topic, T data) {
        this.keyRefHolder.set(this.keyReferenceExtractor.extractKeyReference(topic, data));
        return this.rawSerializer.serialize(topic, data);
    }

    public void close() {
        this.rawSerializer.close();
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        headers.add("keKeyReference", this.keyReferenceExtractor.extractKeyReference(topic, data));
        return this.rawSerializer.serialize(topic, headers, data);
    }
}

