/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto.pairing.serdes;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.processor.StateStore;

public class SerdesPair<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public SerdesPair(Serde<K> keySerde, Serde<V> valueSerde) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public Serde<K> getKeySerde() {
        return this.keySerde;
    }

    public Serde<V> getValueSerde() {
        return this.valueSerde;
    }

    public Serialized<K, V> toSerialized() {
        return Serialized.with(this.keySerde, this.valueSerde);
    }

    public Grouped<K, V> toGrouped() {
        return Grouped.with(this.keySerde, this.valueSerde);
    }

    public Produced<K, V> toProduced() {
        return Produced.with(this.keySerde, this.valueSerde);
    }

    public Consumed<K, V> toConsumed() {
        return Consumed.with(this.keySerde, this.valueSerde);
    }

    public <S extends StateStore> Materialized<K, V, S> applyTo(Materialized<K, V, S> materialized) {
        return materialized.withKeySerde(this.keySerde).withValueSerde(this.valueSerde);
    }
}

