/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto.pairing.serializer;

import io.quicksign.kafka.crypto.CryptoSerializer;
import io.quicksign.kafka.crypto.Encryptor;
import io.quicksign.kafka.crypto.pairing.internal.CryptoAwareSerializerWrapper;
import io.quicksign.kafka.crypto.pairing.keyextractor.KeyReferenceExtractor;
import io.quicksign.kafka.crypto.pairing.serializer.SerializerPair;
import io.quicksign.kafka.crypto.pairing.serializer.SerializerPairFactory;
import org.apache.kafka.common.serialization.Serializer;

public class CryptoSerializerPairFactory
implements SerializerPairFactory {
    private final Encryptor encryptor;
    private final KeyReferenceExtractor keyReferenceExtractor;

    public CryptoSerializerPairFactory(Encryptor encryptor, KeyReferenceExtractor keyReferenceExtractor) {
        this.encryptor = encryptor;
        this.keyReferenceExtractor = keyReferenceExtractor;
    }

    @Override
    public <K, V> SerializerPair<K, V> build(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        CryptoAwareSerializerWrapper<K> newKeySerializer = new CryptoAwareSerializerWrapper<K>(keySerializer, this.keyReferenceExtractor, null);
        CryptoSerializer<V> newvalueSerializer = new CryptoSerializer<V>(valueSerializer, this.encryptor, null);
        return new SerializerPair<K, V>(newKeySerializer, newvalueSerializer);
    }
}

