/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public class MultiFileConcatSource {
    protected ByteArrayOutputStream contents = new ByteArrayOutputStream();

    public MultiFileConcatSource add(InputStream is) throws IOException {
        int read;
        byte[] buffer = new byte[2048];
        while ((read = is.read(buffer)) > 0) {
            this.contents.write(buffer, 0, read);
        }
        return this;
    }

    public MultiFileConcatSource add(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            MultiFileConcatSource multiFileConcatSource = this.add(is);
            return multiFileConcatSource;
        }
    }

    public MultiFileConcatSource add(Path fileName) throws IOException {
        return this.add(fileName.toFile());
    }

    public MultiFileConcatSource add(String fileName) throws IOException {
        try (FileInputStream is = new FileInputStream(fileName);){
            MultiFileConcatSource multiFileConcatSource = this.add(is);
            return multiFileConcatSource;
        }
    }

    public int size() {
        return this.contents.size();
    }

    public ByteArrayInputStream build() {
        return new ByteArrayInputStream(this.contents.toByteArray());
    }

    public static MultiFileConcatSource empty() {
        return new MultiFileConcatSource();
    }

    public static MultiFileConcatSource fromFiles(File ... paths) throws IOException {
        MultiFileConcatSource b = new MultiFileConcatSource();
        for (File f : paths) {
            b.add(f);
        }
        return b;
    }

    public static MultiFileConcatSource fromFiles(Path ... paths) throws IOException {
        MultiFileConcatSource b = new MultiFileConcatSource();
        for (Path p : paths) {
            b.add(p);
        }
        return b;
    }

    public static MultiFileConcatSource fromFiles(String ... paths) throws IOException {
        MultiFileConcatSource b = new MultiFileConcatSource();
        for (String s : paths) {
            b.add(s);
        }
        return b;
    }
}

