/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import io.r2.simplepemkeystore.spi.PemCertKey;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class BasePemKeyStore
extends KeyStoreSpi {
    protected Map<String, PemCertKey> store = new ConcurrentHashMap<String, PemCertKey>();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PemCertKey certKey = this.store.get(alias);
        if (certKey == null) {
            return null;
        }
        return certKey.getPrivateKey();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        PemCertKey certKey = this.store.get(alias);
        if (certKey == null) {
            return null;
        }
        return certKey.getCertificateChain();
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        PemCertKey certKey = this.store.get(alias);
        if (certKey == null) {
            return null;
        }
        return certKey.getCertificate();
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        PemCertKey certKey = this.store.get(alias);
        if (certKey == null) {
            return null;
        }
        return certKey.getCreationDate();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Operation not implemented");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Operation not implemented");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Operation not implemented");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("Operation not implemented");
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.store.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.store.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.store.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        PemCertKey certKey = this.store.get(alias);
        if (certKey == null) {
            return false;
        }
        return certKey.hasKey();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        PemCertKey certKey = this.store.get(alias);
        if (certKey == null) {
            return false;
        }
        return certKey.hasCertificate();
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return this.store.entrySet().stream().filter(e -> ((PemCertKey)e.getValue()).matchesCertificate(cert)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new CertificateException("Store not supported");
    }
}

