/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import io.r2.simplepemkeystore.ExpiringCacheKeyManagerParameters;
import io.r2.simplepemkeystore.spi.ExpiringCacheKeyManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;

public class ExpiringCacheKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    protected KeyManager keyManager = null;

    @Override
    protected void engineInit(KeyStore keyStore, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.keyManager = new ExpiringCacheKeyManager(ExpiringCacheKeyManagerParameters.forKeyStore(keyStore, password));
    }

    @Override
    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof ExpiringCacheKeyManagerParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be instance of ExpiringCacheKeyManagerParameters");
        }
        ExpiringCacheKeyManagerParameters inParams = (ExpiringCacheKeyManagerParameters)params;
        if (inParams.getCacheRevalidation() < 5L) {
            throw new InvalidAlgorithmParameterException("Cache expiration time must be at least 5 seconds");
        }
        try {
            this.keyManager = new ExpiringCacheKeyManager(inParams);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (this.keyManager == null) {
            throw new IllegalStateException("Not initialized");
        }
        return new KeyManager[]{this.keyManager};
    }
}

