/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import io.r2.simplepemkeystore.spi.PemStreamParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

class PemCertKey {
    protected Date creationDate;
    protected Key privateKey;
    protected List<Certificate> certificateChain;
    protected Certificate[] certificateChainPacked;

    public PemCertKey(InputStream input) throws IOException, CertificateException, NoSuchAlgorithmException {
        this(input, new Date());
    }

    public PemCertKey(InputStream input, Date creationDate) throws IOException, CertificateException, NoSuchAlgorithmException {
        this.creationDate = creationDate;
        this.privateKey = null;
        this.certificateChain = new ArrayList<Certificate>();
        PemStreamParser.parse(input, (type, chunk) -> {
            switch (type) {
                case certificate: {
                    this.addCertificate(chunk);
                    break;
                }
                case key: {
                    this.setPrivateKey(chunk);
                }
            }
        });
        this.certificateChainPacked = this.certificateChain.toArray(new Certificate[this.certificateChain.size()]);
    }

    private void setPrivateKey(List<String> key) throws CertificateException, NoSuchAlgorithmException {
        if (this.privateKey != null) {
            throw new CertificateException("More than one private key in PEM input");
        }
        String b64key = key.subList(1, key.size() - 1).stream().collect(Collectors.joining());
        byte[] binKey = Base64.getDecoder().decode(b64key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(binKey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        try {
            this.privateKey = kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CertificateException(e);
        }
    }

    private void addCertificate(List<String> chunk) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(chunk.stream().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.certificateChain.add(cf.generateCertificate(is));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Key getPrivateKey() throws UnrecoverableKeyException {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChainPacked;
    }

    public Certificate getCertificate() {
        return this.certificateChainPacked.length > 0 ? this.certificateChainPacked[0] : null;
    }

    public boolean hasKey() {
        return this.privateKey != null;
    }

    public boolean hasCertificate() {
        return this.certificateChainPacked.length > 0;
    }

    public boolean matchesCertificate(Certificate other) {
        if (this.certificateChainPacked.length == 0) {
            return false;
        }
        return this.certificateChainPacked[0].equals(other);
    }
}

