/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;

public class PemStreamParser {
    protected InputStream in;

    public PemStreamParser(InputStream in) {
        this.in = in;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(ChunkConsumer consumer) throws IOException, CertificateException, NoSuchAlgorithmException {
        ArrayList<String> chunk = new ArrayList<String>();
        boolean inChunk = false;
        String chunkEndMarker = null;
        ChunkType currentChunkType = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.in));){
            String line;
            block17: while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (inChunk) {
                    if (line.equals(chunkEndMarker)) {
                        chunk.add(line);
                        consumer.accept(currentChunkType, chunk);
                        chunk.clear();
                        inChunk = false;
                        continue;
                    }
                    chunk.add(line);
                    continue;
                }
                switch (line) {
                    case "-----BEGIN CERTIFICATE-----": {
                        chunk.add(line);
                        currentChunkType = ChunkType.certificate;
                        inChunk = true;
                        chunkEndMarker = "-----END CERTIFICATE-----";
                        continue block17;
                    }
                    case "-----BEGIN PRIVATE KEY-----": {
                        chunk.add(line);
                        currentChunkType = ChunkType.key;
                        inChunk = true;
                        chunkEndMarker = "-----END PRIVATE KEY-----";
                        continue block17;
                    }
                }
                throw new CertificateException("Invalid chunk in input");
            }
        }
        if (inChunk) {
            throw new CertificateException("Final chunk not closed");
        }
    }

    public static void parse(InputStream in, ChunkConsumer consumer) throws IOException, CertificateException, NoSuchAlgorithmException {
        new PemStreamParser(in).parse(consumer);
    }

    @FunctionalInterface
    public static interface ChunkConsumer {
        public void accept(ChunkType var1, List<String> var2) throws CertificateException, NoSuchAlgorithmException;
    }

    public static enum ChunkType {
        certificate,
        key;

    }
}

