/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore;

import java.security.KeyStore;
import javax.net.ssl.ManagerFactoryParameters;

public class ExpiringCacheKeyManagerParameters
implements ManagerFactoryParameters {
    public static final long DEFAULT_CACHE_EXPIRATION = 3600L;
    private KeyStore keyStore;
    private char[] password;
    private long cacheRevalidation;

    public ExpiringCacheKeyManagerParameters(KeyStore keyStore) {
        this(keyStore, new char[0]);
    }

    public ExpiringCacheKeyManagerParameters(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
        this.cacheRevalidation = 3600L;
    }

    public ExpiringCacheKeyManagerParameters withPassword(char[] password) {
        this.password = password;
        return this;
    }

    public ExpiringCacheKeyManagerParameters withRevalidation(long revalidation) {
        this.cacheRevalidation = revalidation;
        return this;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getPassword() {
        return this.password;
    }

    public long getCacheRevalidation() {
        return this.cacheRevalidation;
    }

    public static ExpiringCacheKeyManagerParameters forKeyStore(KeyStore keyStore) {
        return new ExpiringCacheKeyManagerParameters(keyStore);
    }

    public static ExpiringCacheKeyManagerParameters forKeyStore(KeyStore keyStore, char[] password) {
        return new ExpiringCacheKeyManagerParameters(keyStore, password);
    }
}

