/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class ReloadablePemKeyStoreConfig {
    public static final long DEFAULT_REFRESH_INTERVAL = 3600L;
    private static final ObjectMapper mapper = new ObjectMapper();
    private long refreshInterval = 3600L;
    private HashMap<String, String[]> certificates = new HashMap();

    @JsonProperty(value="refreshInterval")
    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @JsonProperty(value="certificates")
    public HashMap<String, String[]> getCertificates() {
        return this.certificates;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setCertificates(HashMap<String, String[]> certificates) {
        this.certificates = certificates;
    }

    public ReloadablePemKeyStoreConfig addCertificate(String alias, String[] pemFiles) {
        this.certificates.put(alias, pemFiles);
        return this;
    }

    public ReloadablePemKeyStoreConfig addLetsEncrypt(String alias, String domain) {
        return this.addCertificate(alias, new String[]{"/etc/letsencrypt/live/" + domain + "/fullchain.pem", "/etc/letsencrypt/live/" + domain + "/privkey.pem"});
    }

    public ReloadablePemKeyStoreConfig withRefreshInterval(long interval) {
        this.refreshInterval = interval;
        return this;
    }

    public String asJSON() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "/invalid/";
        }
    }

    public InputStream asInputStream() {
        try {
            return new ByteArrayInputStream(mapper.writeValueAsBytes((Object)this));
        }
        catch (JsonProcessingException e) {
            return new ByteArrayInputStream("/invalid/".getBytes());
        }
    }

    public static ReloadablePemKeyStoreConfig forLetsEncrypt(String domain) {
        return new ReloadablePemKeyStoreConfig().addLetsEncrypt("letsencrypt", domain);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReloadablePemKeyStoreConfig that = (ReloadablePemKeyStoreConfig)o;
        if (this.getRefreshInterval() != that.getRefreshInterval()) {
            return false;
        }
        return this.getCertificates().equals(that.getCertificates());
    }

    public int hashCode() {
        int result = (int)(this.getRefreshInterval() ^ this.getRefreshInterval() >>> 32);
        result = 31 * result + this.getCertificates().hashCode();
        return result;
    }

    public String toString() {
        return this.asJSON();
    }
}

