/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import io.r2.simplepemkeystore.spi.PKCS1Converter;
import io.r2.simplepemkeystore.spi.PemStreamParser;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PemCertKey {
    public static String META_KEY_ALIAS = "alias";
    public static String META_KEY_CREATIONDATE = "creationdate";
    protected String alias = "server";
    protected Date creationDate = new Date();
    protected Map<String, String> metaData;
    protected Key privateKey = null;
    protected List<Certificate> certificateChain = new ArrayList<Certificate>();
    protected Certificate[] certificateChainPacked;

    public PemCertKey() {
        this.metaData = new HashMap<String, String>();
    }

    public PemCertKey build() {
        this.certificateChainPacked = this.certificateChain.toArray(new Certificate[0]);
        return this;
    }

    public void setMetaData(Map<String, String> metaData) throws CertificateException {
        this.metaData = metaData;
        if (metaData.containsKey(META_KEY_ALIAS)) {
            this.alias = metaData.get(META_KEY_ALIAS);
        }
        if (metaData.containsKey(META_KEY_CREATIONDATE)) {
            Instant t;
            try {
                t = Instant.parse(metaData.get(META_KEY_CREATIONDATE));
            }
            catch (DateTimeParseException e) {
                throw new CertificateException(e);
            }
            this.creationDate = Date.from(t);
        }
    }

    public void setPrivateKey(List<String> key, PemStreamParser.ChunkType chunkType) throws CertificateException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec keySpec;
        if (this.privateKey != null) {
            throw new CertificateException("More than one private key in PEM input");
        }
        String b64key = String.join((CharSequence)"", key.subList(1, key.size() - 1));
        byte[] binKey = Base64.getDecoder().decode(b64key);
        switch (chunkType) {
            case pkcs8_key: {
                keySpec = new PKCS8EncodedKeySpec(binKey);
                break;
            }
            case pkcs1_key: {
                keySpec = new PKCS8EncodedKeySpec(PKCS1Converter.toPKCS8(binKey));
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Invalid private key type: " + (Object)((Object)chunkType));
            }
        }
        KeyFactory kf = KeyFactory.getInstance("RSA");
        try {
            this.privateKey = kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new NoSuchAlgorithmException(e);
        }
    }

    public void addCertificate(List<String> chunk) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(String.join((CharSequence)"\n", chunk).getBytes(StandardCharsets.UTF_8));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.certificateChain.add(cf.generateCertificate(is));
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
        this.metaData.put(META_KEY_ALIAS, alias);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        this.metaData.put(META_KEY_CREATIONDATE, creationDate.toInstant().toString());
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public Key getPrivateKey() throws UnrecoverableKeyException {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChainPacked;
    }

    public Certificate getCertificate() {
        return this.certificateChainPacked.length > 0 ? this.certificateChainPacked[0] : null;
    }

    public boolean hasKey() {
        return this.privateKey != null;
    }

    public boolean hasCertificate() {
        return this.certificateChainPacked.length > 0;
    }

    public boolean matchesCertificate(Certificate other) {
        if (this.certificateChainPacked.length == 0) {
            return false;
        }
        return this.certificateChainPacked[0].equals(other);
    }
}

