/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import io.r2.simplepemkeystore.spi.PemCertKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PemStreamParser {
    protected InputStream in;

    public PemStreamParser(InputStream in) {
        this.in = in;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(ChunkConsumer consumer) throws IOException, CertificateException, NoSuchAlgorithmException {
        ArrayList<String> chunk = new ArrayList<String>();
        boolean inChunk = false;
        String chunkEndMarker = null;
        ChunkType currentChunkType = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.in));){
            String line;
            block19: while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (inChunk) {
                    if (line.equals(chunkEndMarker)) {
                        chunk.add(line);
                        consumer.accept(currentChunkType, chunk);
                        chunk.clear();
                        inChunk = false;
                        continue;
                    }
                    chunk.add(line);
                    continue;
                }
                switch (line) {
                    case "-----BEGIN CERTIFICATE-----": {
                        if (chunk.size() > 0) {
                            consumer.accept(ChunkType.metaData, chunk);
                            chunk.clear();
                        }
                        chunk.add(line);
                        currentChunkType = ChunkType.certificate;
                        inChunk = true;
                        chunkEndMarker = "-----END CERTIFICATE-----";
                        continue block19;
                    }
                    case "-----BEGIN PRIVATE KEY-----": {
                        if (chunk.size() > 0) {
                            consumer.accept(ChunkType.metaData, chunk);
                            chunk.clear();
                        }
                        chunk.add(line);
                        currentChunkType = ChunkType.pkcs8_key;
                        inChunk = true;
                        chunkEndMarker = "-----END PRIVATE KEY-----";
                        continue block19;
                    }
                    case "-----BEGIN RSA PRIVATE KEY-----": {
                        if (chunk.size() > 0) {
                            consumer.accept(ChunkType.metaData, chunk);
                            chunk.clear();
                        }
                        chunk.add(line);
                        currentChunkType = ChunkType.pkcs1_key;
                        inChunk = true;
                        chunkEndMarker = "-----END RSA PRIVATE KEY-----";
                        continue block19;
                    }
                }
                if (line.startsWith("-----BEGIN ")) {
                    throw new CertificateException("Invalid chunk in input");
                }
                chunk.add(line);
            }
        }
        if (inChunk) {
            throw new CertificateException("Final chunk not closed");
        }
        if (chunk.size() > 0) {
            throw new CertificateException("Metadata at end of file");
        }
        consumer.accept(ChunkType.end, chunk);
    }

    public static void parse(InputStream in, ChunkConsumer consumer) throws IOException, CertificateException, NoSuchAlgorithmException {
        new PemStreamParser(in).parse(consumer);
    }

    public static Map<String, String> parseMetaData(List<String> metaData) throws CertificateException {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String line : metaData) {
            String[] p = line.split(":", 2);
            if (p.length != 2) {
                throw new CertificateException("Invalid line in metadata: " + line);
            }
            ret.put(p[0].trim().toLowerCase(), p[1].trim());
        }
        return ret;
    }

    public static List<PemCertKey> parseCertificateList(InputStream in) throws IOException, CertificateException, NoSuchAlgorithmException {
        final ArrayList<PemCertKey> list = new ArrayList<PemCertKey>();
        PemStreamParser.parse(in, new ChunkConsumer(){
            PemCertKey pending = null;

            @Override
            public void accept(ChunkType chunkType, List<String> chunk) throws CertificateException, NoSuchAlgorithmException {
                switch (chunkType) {
                    case metaData: {
                        if (this.pending != null) {
                            list.add(this.pending.build());
                        }
                        this.pending = new PemCertKey();
                        this.pending.setMetaData(PemStreamParser.parseMetaData(chunk));
                        break;
                    }
                    case certificate: {
                        if (this.pending == null) {
                            this.pending = new PemCertKey();
                        }
                        this.pending.addCertificate(chunk);
                        break;
                    }
                    case pkcs8_key: 
                    case pkcs1_key: {
                        if (this.pending == null) {
                            this.pending = new PemCertKey();
                        }
                        this.pending.setPrivateKey(chunk, chunkType);
                        break;
                    }
                    case end: {
                        if (this.pending == null) break;
                        list.add(this.pending.build());
                    }
                }
            }
        });
        return list;
    }

    public static PemCertKey parseCertificate(InputStream in) throws IOException, CertificateException, NoSuchAlgorithmException {
        List<PemCertKey> list = PemStreamParser.parseCertificateList(in);
        if (list.size() != 1) {
            throw new CertificateException("Input must contain exactly one certificate");
        }
        return list.get(0);
    }

    public static PemCertKey parseCertificate(InputStream in, String alias, Date creationDate) throws IOException, CertificateException, NoSuchAlgorithmException {
        PemCertKey ret = PemStreamParser.parseCertificate(in);
        ret.setAlias(alias);
        ret.setCreationDate(creationDate);
        return ret;
    }

    @FunctionalInterface
    public static interface ChunkConsumer {
        public void accept(ChunkType var1, List<String> var2) throws CertificateException, NoSuchAlgorithmException;
    }

    public static enum ChunkType {
        certificate,
        pkcs8_key,
        pkcs1_key,
        metaData,
        end;

    }
}

