/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.r2.simplepemkeystore.MultiFileConcatSource;
import io.r2.simplepemkeystore.ReloadablePemKeyStoreConfig;
import io.r2.simplepemkeystore.spi.BasePemKeyStore;
import io.r2.simplepemkeystore.spi.PemCertKey;
import io.r2.simplepemkeystore.spi.PemStreamParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ReloadablePemKeyStoreSpi
extends BasePemKeyStore {
    private ReloadablePemKeyStoreConfig configuration;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        ObjectMapper mapper = new ObjectMapper();
        this.configuration = (ReloadablePemKeyStoreConfig)mapper.readValue(stream, ReloadablePemKeyStoreConfig.class);
        for (String alias : this.configuration.getCertificates().keySet()) {
            this.refreshCertificate(alias);
        }
        this.scheduler.scheduleAtFixedRate(() -> {
            for (String alias : this.configuration.getCertificates().keySet()) {
                try {
                    this.refreshCertificate(alias);
                }
                catch (Exception exception) {}
            }
        }, this.configuration.getRefreshInterval(), this.configuration.getRefreshInterval(), TimeUnit.SECONDS);
    }

    private void refreshCertificate(String alias) throws IOException, CertificateException, NoSuchAlgorithmException {
        String[] files = this.configuration.getCertificates().get(alias);
        long fileTime = 0L;
        for (String f : files) {
            Path path = new File(f).toPath();
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            fileTime = Math.max(fileTime, attr.lastModifiedTime().toMillis());
        }
        Date fileDate = new Date(fileTime);
        PemCertKey old = (PemCertKey)this.store.get(alias);
        if (old == null || old.getCreationDate().before(fileDate)) {
            this.store.put(alias, PemStreamParser.parseCertificate(MultiFileConcatSource.fromFiles(files).build(), alias, fileDate));
        }
    }
}

