/*
 * Decompiled with CFR 0.152.
 */
package io.r2.simplepemkeystore.spi;

import io.r2.simplepemkeystore.spi.BasePemKeyStore;
import io.r2.simplepemkeystore.spi.PemCertKey;
import io.r2.simplepemkeystore.spi.PemStreamParser;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;

public class SimplePemKeyStoreSpi
extends BasePemKeyStore {
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        List<PemCertKey> certList = PemStreamParser.parseCertificateList(stream);
        HashMap<String, PemCertKey> newCerts = new HashMap<String, PemCertKey>();
        for (PemCertKey certkey : certList) {
            String alias = certkey.getAlias();
            if (newCerts.putIfAbsent(alias, certkey) == null) continue;
            throw new CertificateException("Multiple entries with the same alias: " + alias);
        }
        this.store.putAll(newCerts);
    }
}

