/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.evaluator;

import io.rapidpro.expressions.EvaluationContext;
import io.rapidpro.expressions.EvaluationError;
import io.rapidpro.expressions.ExcellentBaseVisitor;
import io.rapidpro.expressions.ExcellentParser;
import io.rapidpro.expressions.evaluator.Conversions;
import io.rapidpro.expressions.functions.FunctionManager;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.Pair;
import org.threeten.bp.Duration;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.Period;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAmount;

public class ExpressionVisitorImpl
extends ExcellentBaseVisitor<Object> {
    private FunctionManager m_functions;
    private EvaluationContext m_evalContext;

    public ExpressionVisitorImpl(FunctionManager functions, EvaluationContext context) {
        this.m_functions = functions;
        this.m_evalContext = context;
    }

    @Override
    public Object visitParse(ExcellentParser.ParseContext ctx) {
        return this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Object visitFunctionCall(ExcellentParser.FunctionCallContext ctx) {
        String funcName = ctx.fnname().getText();
        List parameters = ctx.parameters() != null ? (List)this.visit((ParseTree)ctx.parameters()) : Collections.emptyList();
        return this.m_functions.invokeFunction(this.m_evalContext, funcName, parameters);
    }

    @Override
    public Object visitFunctionParameters(ExcellentParser.FunctionParametersContext ctx) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (ExcellentParser.ExpressionContext expression : ctx.expression()) {
            parameters.add(this.visit((ParseTree)expression));
        }
        return parameters;
    }

    @Override
    public Object visitNegation(ExcellentParser.NegationContext ctx) {
        return Conversions.toDecimal(this.visit((ParseTree)ctx.expression()), this.m_evalContext).negate();
    }

    @Override
    public Object visitExponentExpression(ExcellentParser.ExponentExpressionContext ctx) {
        BigDecimal arg1 = Conversions.toDecimal(this.visit((ParseTree)ctx.expression(0)), this.m_evalContext);
        BigDecimal arg2 = Conversions.toDecimal(this.visit((ParseTree)ctx.expression(1)), this.m_evalContext);
        return ExpressionUtils.decimalPow(arg1, arg2);
    }

    @Override
    public Object visitMultiplicationOrDivisionExpression(ExcellentParser.MultiplicationOrDivisionExpressionContext ctx) {
        boolean multiplication = ctx.TIMES() != null;
        BigDecimal arg1 = Conversions.toDecimal(this.visit((ParseTree)ctx.expression(0)), this.m_evalContext);
        BigDecimal arg2 = Conversions.toDecimal(this.visit((ParseTree)ctx.expression(1)), this.m_evalContext);
        if (!multiplication && arg2.equals(BigDecimal.ZERO)) {
            throw new EvaluationError("Division by zero");
        }
        return multiplication ? arg1.multiply(arg2) : arg1.divide(arg2, 10, RoundingMode.HALF_UP);
    }

    @Override
    public Object visitAdditionOrSubtractionExpression(ExcellentParser.AdditionOrSubtractionExpressionContext ctx) {
        boolean add = ctx.PLUS() != null;
        Object arg1 = this.visit((ParseTree)ctx.expression(0));
        Object arg2 = this.visit((ParseTree)ctx.expression(1));
        try {
            BigDecimal _arg1 = Conversions.toDecimal(arg1, this.m_evalContext);
            BigDecimal _arg2 = Conversions.toDecimal(arg2, this.m_evalContext);
            return add ? _arg1.add(_arg2) : _arg1.subtract(_arg2);
        }
        catch (EvaluationError ignored) {
            try {
                Period _arg2;
                Temporal _arg1 = Conversions.toDateOrDateTime(arg1, this.m_evalContext);
                if (arg2 instanceof OffsetTime) {
                    _arg1 = Conversions.toDateTime(_arg1, this.m_evalContext);
                    _arg2 = Duration.between((Temporal)LocalTime.of((int)0, (int)0), (Temporal)((OffsetTime)arg2).toLocalTime());
                } else {
                    _arg2 = Period.ofDays((int)Conversions.toInteger(arg2, this.m_evalContext));
                }
                return add ? _arg1.plus((TemporalAmount)_arg2) : _arg1.minus((TemporalAmount)_arg2);
            }
            catch (EvaluationError ex) {
                throw new EvaluationError("Expression could not be evaluated as decimal or date arithmetic", ex);
            }
        }
    }

    @Override
    public Object visitComparisonExpression(ExcellentParser.ComparisonExpressionContext ctx) {
        Pair<Object, Object> args = Conversions.toSame(this.visit((ParseTree)ctx.expression(0)), this.visit((ParseTree)ctx.expression(1)), this.m_evalContext);
        int compared = args.getLeft() instanceof String ? ((String)args.getLeft()).compareToIgnoreCase((String)args.getRight()) : ((Comparable)args.getLeft()).compareTo(args.getRight());
        if (ctx.LTE() != null) {
            return compared <= 0;
        }
        if (ctx.LT() != null) {
            return compared < 0;
        }
        if (ctx.GTE() != null) {
            return compared >= 0;
        }
        return compared > 0;
    }

    @Override
    public Object visitEqualityExpression(ExcellentParser.EqualityExpressionContext ctx) {
        Pair<Object, Object> args = Conversions.toSame(this.visit((ParseTree)ctx.expression(0)), this.visit((ParseTree)ctx.expression(1)), this.m_evalContext);
        boolean equal = args.getLeft() instanceof String ? ((String)args.getLeft()).equalsIgnoreCase((String)args.getRight()) : (args.getLeft() instanceof BigDecimal ? ((BigDecimal)args.getLeft()).compareTo((BigDecimal)args.getRight()) == 0 : args.getLeft().equals(args.getRight()));
        return ctx.EQ() != null ? equal : !equal;
    }

    @Override
    public Object visitConcatenation(ExcellentParser.ConcatenationContext ctx) {
        String arg1 = Conversions.toString(this.visit((ParseTree)ctx.expression(0)), this.m_evalContext);
        String arg2 = Conversions.toString(this.visit((ParseTree)ctx.expression(1)), this.m_evalContext);
        return arg1 + arg2;
    }

    @Override
    public Object visitStringLiteral(ExcellentParser.StringLiteralContext ctx) {
        String raw = ctx.STRING().getText();
        String val = raw.substring(1, raw.length() - 1);
        return val.replaceAll("\"\"", "\"");
    }

    @Override
    public Object visitDecimalLiteral(ExcellentParser.DecimalLiteralContext ctx) {
        return new BigDecimal(ctx.DECIMAL().getText());
    }

    @Override
    public Object visitTrue(ExcellentParser.TrueContext ctx) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitFalse(ExcellentParser.FalseContext ctx) {
        return Boolean.FALSE;
    }

    @Override
    public Object visitContextReference(ExcellentParser.ContextReferenceContext ctx) {
        String identifier = ctx.NAME().getText();
        Object value = this.m_evalContext.resolveVariable(identifier);
        return value != null ? value : "";
    }

    @Override
    public Object visitParentheses(ExcellentParser.ParenthesesContext ctx) {
        return this.visit((ParseTree)ctx.expression());
    }
}

