/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class Parameter {
    protected Class<?> m_type;
    protected Annotation[] m_annotations;

    protected Parameter(Class<?> type, Annotation[] annotations) {
        this.m_type = type;
        this.m_annotations = annotations;
    }

    public static Parameter[] fromMethod(Method method) {
        Class<?>[] types = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        int numParams = types.length;
        Parameter[] params = new Parameter[numParams];
        for (int p = 0; p < numParams; ++p) {
            params[p] = new Parameter(types[p], annotations[p]);
        }
        return params;
    }

    public <T> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.m_annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (T)annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.m_annotations;
    }

    public Class<?> getType() {
        return this.m_type;
    }
}

