/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.functions;

import io.rapidpro.expressions.EvaluationContext;
import io.rapidpro.expressions.EvaluationError;
import io.rapidpro.expressions.evaluator.Conversions;
import io.rapidpro.expressions.functions.annotations.BooleanDefault;
import io.rapidpro.expressions.functions.annotations.IntegerDefault;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;

public class ExcelFunctions {
    public static String _char(EvaluationContext ctx, Object number) {
        return "" + (char)Conversions.toInteger(number, ctx);
    }

    public static String clean(EvaluationContext ctx, Object text) {
        return Conversions.toString(text, ctx).replaceAll("\\p{C}", "");
    }

    public static int code(EvaluationContext ctx, Object text) {
        return ExcelFunctions.unicode(ctx, text);
    }

    public static String concatenate(EvaluationContext ctx, Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(Conversions.toString(arg, ctx));
        }
        return sb.toString();
    }

    public static String fixed(EvaluationContext ctx, Object number, @IntegerDefault(value=2) Object decimals, @BooleanDefault(value=false) Object noCommas) {
        BigDecimal _number = Conversions.toDecimal(number, ctx);
        _number = _number.setScale(Conversions.toInteger(decimals, ctx), RoundingMode.HALF_UP);
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(9);
        format.setGroupingUsed(!Conversions.toBoolean(noCommas, ctx));
        return format.format(_number);
    }

    public static String left(EvaluationContext ctx, Object text, Object numChars) {
        int _numChars = Conversions.toInteger(numChars, ctx);
        if (_numChars < 0) {
            throw new RuntimeException("Number of chars can't be negative");
        }
        return StringUtils.left((String)Conversions.toString(text, ctx), (int)_numChars);
    }

    public static int len(EvaluationContext ctx, Object text) {
        return Conversions.toString(text, ctx).length();
    }

    public static String lower(EvaluationContext ctx, Object text) {
        return Conversions.toString(text, ctx).toLowerCase();
    }

    public static String proper(EvaluationContext ctx, Object text) {
        String _text = Conversions.toString(text, ctx).toLowerCase();
        if (!StringUtils.isEmpty((CharSequence)_text)) {
            char[] buffer = _text.toCharArray();
            boolean capitalizeNext = true;
            for (int i = 0; i < buffer.length; ++i) {
                char ch = buffer[i];
                if (!Character.isAlphabetic(ch)) {
                    capitalizeNext = true;
                    continue;
                }
                if (!capitalizeNext) continue;
                buffer[i] = Character.toTitleCase(ch);
                capitalizeNext = false;
            }
            return new String(buffer);
        }
        return _text;
    }

    public static String rept(EvaluationContext ctx, Object text, Object numberTimes) {
        int _numberTimes = Conversions.toInteger(numberTimes, ctx);
        if (_numberTimes < 0) {
            throw new RuntimeException("Number of times can't be negative");
        }
        return StringUtils.repeat((String)Conversions.toString(text, ctx), (int)_numberTimes);
    }

    public static String right(EvaluationContext ctx, Object text, Object numChars) {
        int _numChars = Conversions.toInteger(numChars, ctx);
        if (_numChars < 0) {
            throw new RuntimeException("Number of chars can't be negative");
        }
        return StringUtils.right((String)Conversions.toString(text, ctx), (int)_numChars);
    }

    public static String substitute(EvaluationContext ctx, Object text, Object oldText, Object newText, @IntegerDefault(value=-1) Object instanceNum) {
        String _text = Conversions.toString(text, ctx);
        String _oldText = Conversions.toString(oldText, ctx);
        String _newText = Conversions.toString(newText, ctx);
        int _instanceNum = Conversions.toInteger(instanceNum, ctx);
        if (_instanceNum < 0) {
            return _text.replace(_oldText, _newText);
        }
        String[] splits = _text.split(_oldText);
        StringBuilder output = new StringBuilder(splits[0]);
        for (int s = 1; s < splits.length; ++s) {
            String sep = s == _instanceNum ? _newText : _oldText;
            output.append(sep);
            output.append(splits[s]);
        }
        return output.toString();
    }

    public static String unichar(EvaluationContext ctx, Object number) {
        return "" + (char)Conversions.toInteger(number, ctx);
    }

    public static int unicode(EvaluationContext ctx, Object text) {
        String _text = Conversions.toString(text, ctx);
        if (_text.length() == 0) {
            throw new RuntimeException("Text can't be empty");
        }
        return _text.charAt(0);
    }

    public static String upper(EvaluationContext ctx, Object text) {
        return Conversions.toString(text, ctx).toUpperCase();
    }

    public static LocalDate date(EvaluationContext ctx, Object year, Object month, Object day) {
        return LocalDate.of((int)Conversions.toInteger(year, ctx), (int)Conversions.toInteger(month, ctx), (int)Conversions.toInteger(day, ctx));
    }

    public static LocalDate datevalue(EvaluationContext ctx, Object text) {
        return Conversions.toDate(text, ctx);
    }

    public static int day(EvaluationContext ctx, Object date) {
        return Conversions.toDateOrDateTime(date, ctx).get((TemporalField)ChronoField.DAY_OF_MONTH);
    }

    public static Temporal edate(EvaluationContext ctx, Object date, Object months) {
        Temporal dateOrDateTime = Conversions.toDateOrDateTime(date, ctx);
        int _months = Conversions.toInteger(months, ctx);
        return dateOrDateTime.plus((long)_months, (TemporalUnit)ChronoUnit.MONTHS);
    }

    public static int hour(EvaluationContext ctx, Object datetime) {
        return Conversions.toDateTime(datetime, ctx).getHour();
    }

    public static int minute(EvaluationContext ctx, Object datetime) {
        return Conversions.toDateTime(datetime, ctx).getMinute();
    }

    public static int month(EvaluationContext ctx, Object date) {
        return Conversions.toDateOrDateTime(date, ctx).get((TemporalField)ChronoField.MONTH_OF_YEAR);
    }

    public static ZonedDateTime now(EvaluationContext ctx) {
        try {
            return Conversions.toDateTime(ctx.resolveVariable("date.now"), ctx);
        }
        catch (EvaluationError ex) {
            return ZonedDateTime.now((ZoneId)ctx.getTimezone());
        }
    }

    public static int second(EvaluationContext ctx, Object datetime) {
        return Conversions.toDateTime(datetime, ctx).getSecond();
    }

    public static OffsetTime time(EvaluationContext ctx, Object hours, Object minutes, Object seconds) {
        int _hours = Conversions.toInteger(hours, ctx);
        int _minutes = Conversions.toInteger(minutes, ctx);
        int _seconds = Conversions.toInteger(seconds, ctx);
        LocalTime localTime = LocalTime.of((int)_hours, (int)_minutes, (int)_seconds);
        return ZonedDateTime.of((LocalDate)LocalDate.now((ZoneId)ctx.getTimezone()), (LocalTime)localTime, (ZoneId)ctx.getTimezone()).toOffsetDateTime().toOffsetTime();
    }

    public static OffsetTime timevalue(EvaluationContext ctx, Object text) {
        return Conversions.toTime(text, ctx);
    }

    public static LocalDate today(EvaluationContext ctx) {
        try {
            return Conversions.toDate(ctx.resolveVariable("date.today"), ctx);
        }
        catch (EvaluationError ex) {
            return LocalDate.now((ZoneId)ctx.getTimezone());
        }
    }

    public static int weekday(EvaluationContext ctx, Object date) {
        int iso = Conversions.toDateOrDateTime(date, ctx).get((TemporalField)ChronoField.DAY_OF_WEEK);
        return iso < 7 ? iso + 1 : 1;
    }

    public static int year(EvaluationContext ctx, Object date) {
        return Conversions.toDateOrDateTime(date, ctx).get((TemporalField)ChronoField.YEAR);
    }

    public static BigDecimal abs(EvaluationContext ctx, Object number) {
        return Conversions.toDecimal(number, ctx).abs();
    }

    public static int _int(EvaluationContext ctx, Object number) {
        return Conversions.toDecimal(number, ctx).setScale(0, RoundingMode.FLOOR).intValue();
    }

    public static BigDecimal max(EvaluationContext ctx, Object ... args) {
        if (args.length == 0) {
            throw new RuntimeException("Wrong number of arguments");
        }
        BigDecimal result = null;
        for (Object arg : args) {
            BigDecimal _arg = Conversions.toDecimal(arg, ctx);
            result = result != null ? _arg.max(result) : _arg;
        }
        return result;
    }

    public static BigDecimal min(EvaluationContext ctx, Object ... args) {
        if (args.length == 0) {
            throw new RuntimeException("Wrong number of arguments");
        }
        BigDecimal result = null;
        for (Object arg : args) {
            BigDecimal _arg = Conversions.toDecimal(arg, ctx);
            result = result != null ? _arg.min(result) : _arg;
        }
        return result;
    }

    public static BigDecimal mod(EvaluationContext ctx, Object number, Object divisor) {
        BigDecimal _number = Conversions.toDecimal(number, ctx);
        BigDecimal _divisor = Conversions.toDecimal(divisor, ctx);
        return _number.subtract(_divisor.multiply(new BigDecimal(ExcelFunctions._int(ctx, _number.divide(_divisor, 10, RoundingMode.HALF_UP)))));
    }

    public static BigDecimal power(EvaluationContext ctx, Object number, Object power) {
        BigDecimal _number = Conversions.toDecimal(number, ctx);
        BigDecimal _power = Conversions.toDecimal(power, ctx);
        return ExpressionUtils.decimalPow(_number, _power);
    }

    public static BigDecimal rand() {
        return new BigDecimal(Math.random());
    }

    public static int randbetween(EvaluationContext ctx, Object bottom, Object top) {
        int _bottom = Conversions.toInteger(bottom, ctx);
        int _top = Conversions.toInteger(top, ctx);
        return (int)(Math.random() * (double)(_top + 1 - _bottom)) + _bottom;
    }

    public static BigDecimal sum(EvaluationContext ctx, Object ... args) {
        if (args.length == 0) {
            throw new RuntimeException("Wrong number of arguments");
        }
        BigDecimal result = BigDecimal.ZERO;
        for (Object arg : args) {
            result = result.add(Conversions.toDecimal(arg, ctx));
        }
        return result;
    }

    public static boolean and(EvaluationContext ctx, Object ... args) {
        for (Object arg : args) {
            if (Conversions.toBoolean(arg, ctx)) continue;
            return false;
        }
        return true;
    }

    public static boolean _false() {
        return false;
    }

    public static Object _if(EvaluationContext ctx, Object logicalTest, @IntegerDefault(value=0) Object valueIfTrue, @BooleanDefault(value=false) Object valueIfFalse) {
        return Conversions.toBoolean(logicalTest, ctx) ? valueIfTrue : valueIfFalse;
    }

    public static boolean or(EvaluationContext ctx, Object ... args) {
        for (Object arg : args) {
            if (!Conversions.toBoolean(arg, ctx)) continue;
            return true;
        }
        return false;
    }

    public static boolean _true() {
        return true;
    }
}

