/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.functions;

import io.rapidpro.expressions.EvaluationContext;
import io.rapidpro.expressions.EvaluationError;
import io.rapidpro.expressions.evaluator.Conversions;
import io.rapidpro.expressions.functions.annotations.BooleanDefault;
import io.rapidpro.expressions.functions.annotations.IntegerDefault;
import io.rapidpro.expressions.functions.annotations.StringDefault;
import io.rapidpro.expressions.utils.Parameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FunctionManager {
    private Map<String, Method> m_functions = new HashMap<String, Method>();

    public void addLibrary(Class<?> library) {
        for (Method method : library.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) == 0) continue;
            String name = method.getName().toLowerCase();
            if (name.startsWith("_")) {
                name = name.substring(1);
            }
            this.m_functions.put(name, method);
        }
    }

    public Method getFunction(String name) {
        return this.m_functions.get(name.toLowerCase());
    }

    public Object invokeFunction(EvaluationContext ctx, String name, List<Object> args) {
        Method func = this.getFunction(name);
        if (func == null) {
            throw new EvaluationError("Undefined function: " + name);
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Object> remainingArgs = new ArrayList<Object>(args);
        for (Parameter param : Parameter.fromMethod(func)) {
            BooleanDefault defaultBool = param.getAnnotation(BooleanDefault.class);
            IntegerDefault defaultInt = param.getAnnotation(IntegerDefault.class);
            StringDefault defaultStr = param.getAnnotation(StringDefault.class);
            if (param.getType().equals(EvaluationContext.class)) {
                parameters.add(ctx);
                continue;
            }
            if (param.getType().isArray()) {
                parameters.add(remainingArgs.toArray(new Object[remainingArgs.size()]));
                remainingArgs.clear();
                break;
            }
            if (remainingArgs.size() > 0) {
                Object arg = remainingArgs.remove(0);
                parameters.add(arg);
                continue;
            }
            if (defaultBool != null) {
                parameters.add(defaultBool.value());
                continue;
            }
            if (defaultInt != null) {
                parameters.add(defaultInt.value());
                continue;
            }
            if (defaultStr != null) {
                parameters.add(defaultStr.value());
                continue;
            }
            throw new EvaluationError("Too few arguments provided for function " + name);
        }
        if (!remainingArgs.isEmpty()) {
            throw new EvaluationError("Too many arguments provided for function " + name);
        }
        try {
            return func.invoke(null, parameters.toArray(new Object[parameters.size()]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ArrayList<String> prettyArgs = new ArrayList<String>();
            for (Object arg : args) {
                String pretty;
                if (arg instanceof String) {
                    pretty = "\"" + arg + "\"";
                } else {
                    try {
                        pretty = Conversions.toString(arg, ctx);
                    }
                    catch (EvaluationError ex) {
                        pretty = arg.toString();
                    }
                }
                prettyArgs.add(pretty);
            }
            throw new EvaluationError("Error calling function " + name + " with arguments " + StringUtils.join(prettyArgs, (String)", "), e);
        }
    }

    public List<FunctionDescriptor> buildListing() {
        ArrayList<FunctionDescriptor> listing = new ArrayList<FunctionDescriptor>();
        for (Map.Entry<String, Method> entry : this.m_functions.entrySet()) {
            FunctionDescriptor descriptor = new FunctionDescriptor(entry.getKey().toUpperCase(), null);
            listing.add(descriptor);
        }
        Collections.sort(listing, new Comparator<FunctionDescriptor>(){

            @Override
            public int compare(FunctionDescriptor f1, FunctionDescriptor f2) {
                return f1.m_name.compareTo(f2.m_name);
            }
        });
        return listing;
    }

    public static class FunctionDescriptor {
        protected String m_name;
        protected String m_description;

        public FunctionDescriptor(String name, String description) {
            this.m_name = name;
            this.m_description = description;
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

