/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.utils;

import io.rapidpro.expressions.dates.DateStyle;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.threeten.bp.format.DateTimeFormatter;

public class ExpressionUtils {
    public static <T> List<T> slice(List<T> list, Integer start, Integer stop) {
        int size = list.size();
        if (start == null) {
            start = 0;
        } else if (start < 0) {
            start = size + start;
        }
        if (stop == null) {
            stop = size;
        } else if (stop < 0) {
            stop = size + stop;
        }
        if (start >= size || stop <= 0 || start >= stop) {
            return Collections.emptyList();
        }
        start = Math.max(0, start);
        stop = Math.min(size, stop);
        return list.subList(start, stop);
    }

    public static BigDecimal decimalPow(BigDecimal number, BigDecimal power) {
        return new BigDecimal(Math.pow(number.doubleValue(), power.doubleValue()));
    }

    public static String urlquote(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DateTimeFormatter getDateFormatter(DateStyle dateStyle, boolean incTime) {
        String format = dateStyle.equals((Object)DateStyle.DAY_FIRST) ? "dd-MM-yyyy" : "MM-dd-yyyy";
        return DateTimeFormatter.ofPattern((String)(incTime ? format + " HH:mm" : format));
    }

    public static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public static String[] tokenize(String text) {
        int len = text.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            int ch = text.codePointAt(i);
            if (!Character.isDigit(ch) && ch != 95 && !Character.isAlphabetic(ch)) {
                if (match) {
                    list.add(text.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(text.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }
}

