/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.dates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DateLexer {
    public List<Token> tokenize(String text) {
        int length = text.length();
        if (length == 0) {
            return Collections.emptyList();
        }
        State state = State.IGNORED;
        Token.Type currentTokenType = null;
        int currentTokenStart = -1;
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int pos = 0; pos < length; ++pos) {
            State prevState = state;
            int ch = text.codePointAt(pos);
            if (prevState == (state = Character.isAlphabetic(ch) ? State.ALPHABETIC_TOKEN : (Character.isDigit(ch) ? State.NUMERIC_TOKEN : State.IGNORED))) continue;
            if (prevState != State.IGNORED) {
                tokens.add(new Token(currentTokenType, text.substring(currentTokenStart, pos), currentTokenStart, pos));
            }
            if (state == State.IGNORED) continue;
            currentTokenType = state == State.NUMERIC_TOKEN ? Token.Type.NUMERIC : Token.Type.ALPHABETIC;
            currentTokenStart = pos;
        }
        if (state != State.IGNORED) {
            tokens.add(new Token(currentTokenType, text.substring(currentTokenStart, length), currentTokenStart, length));
        }
        return tokens;
    }

    public static class Token {
        protected Type m_type;
        protected String m_text;
        protected int m_start;
        protected int m_end;

        public Token(Type type, String text, int start, int end) {
            this.m_type = type;
            this.m_text = text;
            this.m_start = start;
            this.m_end = end;
        }

        public Type getType() {
            return this.m_type;
        }

        public String getText() {
            return this.m_text;
        }

        public int getStart() {
            return this.m_start;
        }

        public int getEnd() {
            return this.m_end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token other = (Token)o;
            return this.m_type == other.m_type && this.m_text.equals(other.m_text) && this.m_start == other.m_start && this.m_end == other.m_end;
        }

        public static enum Type {
            NUMERIC,
            ALPHABETIC;

        }
    }

    protected static enum State {
        IGNORED,
        NUMERIC_TOKEN,
        ALPHABETIC_TOKEN;

    }
}

