/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.dates;

import io.rapidpro.expressions.dates.DateLexer;
import io.rapidpro.expressions.dates.DateStyle;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.Temporal;

public class DateParser {
    protected static final DateLexer LEXER = new DateLexer();
    protected static final Map<String, Integer> MONTHS_BY_ALIAS;
    protected static final int AM = 0;
    protected static final int PM = 1;
    protected static final Component[][] DATE_SEQUENCES_DAY_FIRST;
    protected static final Component[][] DATE_SEQUENCES_MONTH_FIRST;
    protected static final Component[][] TIME_SEQUENCES;
    protected final LocalDate m_now;
    protected final ZoneId m_timezone;
    protected final DateStyle m_dateStyle;

    public DateParser(LocalDate now, ZoneId timezone, DateStyle dateStyle) {
        this.m_now = now;
        this.m_timezone = timezone;
        this.m_dateStyle = dateStyle;
    }

    public Temporal auto(String text) {
        Result result = this.parse(text, Mode.AUTO);
        return result != null ? result.getValue() : null;
    }

    public Result autoWithLocation(String text) {
        return this.parse(text, Mode.AUTO);
    }

    public OffsetTime time(String text) {
        Result result = this.parse(text, Mode.TIME);
        return result != null ? (OffsetTime)result.getValue() : null;
    }

    protected Result parse(String text, Mode mode) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        List<DateLexer.Token> tokens = LEXER.tokenize(text);
        int startPos = -1;
        int endPos = -1;
        ArrayList<Map<Component, Integer>> tokenPossibilities = new ArrayList<Map<Component, Integer>>();
        for (DateLexer.Token token : tokens) {
            Map<Component, Integer> possibilities = DateParser.getTokenPossibilities(token, mode);
            if (possibilities.size() <= 0) continue;
            tokenPossibilities.add(possibilities);
            if (startPos < 0) {
                startPos = token.getStart();
            }
            if (token.getEnd() <= endPos) continue;
            endPos = token.getEnd();
        }
        List<Component[]> sequences = DateParser.getPossibleSequences(mode, tokenPossibilities.size(), this.m_dateStyle);
        block1: for (Component[] sequence : sequences) {
            LinkedHashMap<Component, Integer> match = new LinkedHashMap<Component, Integer>();
            for (int c = 0; c < sequence.length; ++c) {
                Component component = sequence[c];
                Integer value = (Integer)((Map)tokenPossibilities.get(c)).get((Object)component);
                match.put(component, value);
                if (value == null) continue block1;
            }
            Temporal obj = DateParser.makeResult(match, this.m_now, this.m_timezone);
            if (obj == null) continue;
            return new Result(obj, startPos, endPos);
        }
        return null;
    }

    protected static List<Component[]> getPossibleSequences(Mode mode, int length, DateStyle dateStyle) {
        Component[][] dateSequences;
        ArrayList<Component[]> sequences = new ArrayList<Component[]>();
        Component[][] componentArray = dateSequences = dateStyle.equals((Object)DateStyle.DAY_FIRST) ? DATE_SEQUENCES_DAY_FIRST : DATE_SEQUENCES_MONTH_FIRST;
        if (mode == Mode.DATE || mode == Mode.AUTO) {
            for (Component[] seq : dateSequences) {
                if (seq.length != length) continue;
                sequences.add(seq);
            }
        } else if (mode == Mode.TIME) {
            for (Component[] seq : TIME_SEQUENCES) {
                if (seq.length != length) continue;
                sequences.add(seq);
            }
        }
        if (mode == Mode.DATETIME || mode == Mode.AUTO) {
            for (Component[] dateSeq : dateSequences) {
                for (Component[] timeSeq : TIME_SEQUENCES) {
                    if (dateSeq.length + timeSeq.length != length) continue;
                    sequences.add((Component[])ArrayUtils.addAll((Object[])dateSeq, (Object[])timeSeq));
                }
            }
        }
        return sequences;
    }

    protected static Map<Component, Integer> getTokenPossibilities(DateLexer.Token token, Mode mode) {
        HashMap<Component, Integer> possibilities = new HashMap<Component, Integer>();
        String text = token.getText().toLowerCase();
        if (token.getType() == DateLexer.Token.Type.NUMERIC) {
            int asInt = Integer.parseInt(token.getText());
            if (mode != Mode.TIME) {
                if (asInt >= 1 && asInt <= 9999 && (text.length() == 2 || text.length() == 4)) {
                    possibilities.put(Component.YEAR, asInt);
                }
                if (asInt >= 1 && asInt <= 12) {
                    possibilities.put(Component.MONTH, asInt);
                }
                if (asInt >= 1 && asInt <= 31) {
                    possibilities.put(Component.DAY, asInt);
                }
            }
            if (mode != Mode.DATE) {
                if (asInt >= 0 && asInt <= 23) {
                    possibilities.put(Component.HOUR, asInt);
                }
                if (asInt >= 0 && asInt <= 59) {
                    possibilities.put(Component.MINUTE, asInt);
                }
                if (asInt >= 0 && asInt <= 59) {
                    possibilities.put(Component.SECOND, asInt);
                }
                if (text.length() == 3 || text.length() == 6 || text.length() == 9) {
                    int nano = 0;
                    if (text.length() == 3) {
                        nano = asInt * 1000000;
                    } else if (text.length() == 6) {
                        nano = asInt * 1000;
                    } else if (text.length() == 9) {
                        nano = asInt;
                    }
                    possibilities.put(Component.NANO, nano);
                }
                if (text.length() == 4) {
                    int hour = asInt / 100;
                    int minute = asInt - hour * 100;
                    if (hour >= 1 && hour <= 24 && minute >= 1 && minute <= 59) {
                        possibilities.put(Component.HOUR_AND_MINUTE, asInt);
                    }
                }
            }
        } else if (token.getType() == DateLexer.Token.Type.ALPHABETIC) {
            Integer month;
            if (mode != Mode.TIME && (month = MONTHS_BY_ALIAS.get(text)) != null) {
                possibilities.put(Component.MONTH, month);
            }
            if (mode != Mode.DATE) {
                boolean isAmMarker = text.equals("am");
                boolean isPmMarker = text.equals("pm");
                if (isAmMarker || isPmMarker) {
                    possibilities.put(Component.AM_PM, isAmMarker ? 0 : 1);
                }
                if (text.equals("z")) {
                    possibilities.put(Component.OFFSET, 0);
                }
            }
        }
        return possibilities;
    }

    protected static Temporal makeResult(Map<Component, Integer> values, LocalDate now, ZoneId timezone) {
        LocalDate date = null;
        LocalTime time = null;
        if (values.containsKey((Object)Component.MONTH)) {
            int year = DateParser.yearFrom2Digits(ExpressionUtils.getOrDefault(values, Component.YEAR, now.getYear()), now.getYear());
            int month = values.get((Object)Component.MONTH);
            int day = ExpressionUtils.getOrDefault(values, Component.DAY, 1);
            try {
                date = LocalDate.of((int)year, (int)month, (int)day);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        if (values.containsKey((Object)Component.HOUR) && values.containsKey((Object)Component.MINUTE) || values.containsKey((Object)Component.HOUR_AND_MINUTE)) {
            int nano;
            int second;
            int minute;
            int hour;
            if (values.containsKey((Object)Component.HOUR_AND_MINUTE)) {
                int combined = values.get((Object)Component.HOUR_AND_MINUTE);
                hour = combined / 100;
                minute = combined - hour * 100;
                second = 0;
                nano = 0;
            } else {
                hour = values.get((Object)Component.HOUR);
                minute = values.get((Object)Component.MINUTE);
                second = ExpressionUtils.getOrDefault(values, Component.SECOND, 0);
                nano = ExpressionUtils.getOrDefault(values, Component.NANO, 0);
                if (hour <= 12 && ExpressionUtils.getOrDefault(values, Component.AM_PM, 0) == 1) {
                    hour += 12;
                }
            }
            try {
                time = LocalTime.of((int)hour, (int)minute, (int)second, (int)nano);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        if (values.containsKey((Object)Component.OFFSET)) {
            timezone = ZoneOffset.ofTotalSeconds((int)values.get((Object)Component.OFFSET));
        }
        if (date != null && time != null) {
            return ZonedDateTime.of(date, time, (ZoneId)timezone);
        }
        if (date != null) {
            return date;
        }
        if (time != null) {
            return ZonedDateTime.of((LocalDate)now, time, (ZoneId)timezone).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    protected static int yearFrom2Digits(int shortYear, int currentYear) {
        if (shortYear < 100 && Math.abs((shortYear += currentYear - currentYear % 100) - currentYear) >= 50) {
            if (shortYear < currentYear) {
                return shortYear + 100;
            }
            return shortYear - 100;
        }
        return shortYear;
    }

    protected static Map<String, Integer> loadMonthAliases(String file) throws IOException {
        String line;
        InputStream in = DateParser.class.getClassLoader().getResourceAsStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int month = 1;
        while ((line = reader.readLine()) != null) {
            for (String alias : line.split(",")) {
                map.put(alias, month);
            }
            ++month;
        }
        reader.close();
        return map;
    }

    static {
        try {
            MONTHS_BY_ALIAS = DateParser.loadMonthAliases("month.aliases");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DATE_SEQUENCES_DAY_FIRST = new Component[][]{{Component.DAY, Component.MONTH, Component.YEAR}, {Component.MONTH, Component.DAY, Component.YEAR}, {Component.YEAR, Component.MONTH, Component.DAY}, {Component.DAY, Component.MONTH}, {Component.MONTH, Component.DAY}, {Component.MONTH, Component.YEAR}};
        DATE_SEQUENCES_MONTH_FIRST = new Component[][]{{Component.MONTH, Component.DAY, Component.YEAR}, {Component.DAY, Component.MONTH, Component.YEAR}, {Component.YEAR, Component.MONTH, Component.DAY}, {Component.MONTH, Component.DAY}, {Component.DAY, Component.MONTH}, {Component.MONTH, Component.YEAR}};
        TIME_SEQUENCES = new Component[][]{{Component.HOUR_AND_MINUTE}, {Component.HOUR, Component.MINUTE}, {Component.HOUR, Component.MINUTE, Component.AM_PM}, {Component.HOUR, Component.MINUTE, Component.SECOND}, {Component.HOUR, Component.MINUTE, Component.SECOND, Component.AM_PM}, {Component.HOUR, Component.MINUTE, Component.SECOND, Component.NANO}, {Component.HOUR, Component.MINUTE, Component.SECOND, Component.NANO, Component.OFFSET}};
    }

    public static class Result {
        protected Temporal m_value;
        protected int m_start;
        protected int m_end;

        public Result(Temporal value, int start, int end) {
            this.m_value = value;
            this.m_start = start;
            this.m_end = end;
        }

        public Temporal getValue() {
            return this.m_value;
        }

        public int getStart() {
            return this.m_start;
        }

        public int getEnd() {
            return this.m_end;
        }
    }

    protected static enum Component {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        HOUR_AND_MINUTE,
        SECOND,
        NANO,
        AM_PM,
        OFFSET;

    }

    protected static enum Mode {
        DATE,
        DATETIME,
        TIME,
        AUTO;

    }
}

