/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.rapidpro.expressions.EvaluationError;
import io.rapidpro.expressions.dates.DateParser;
import io.rapidpro.expressions.dates.DateStyle;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;

public class EvaluationContext {
    protected static Gson s_gson = new GsonBuilder().registerTypeAdapter(EvaluationContext.class, (Object)new Deserializer()).serializeNulls().create();
    protected Map<String, Object> m_variables;
    protected ZoneId m_timezone;
    protected DateStyle m_dateStyle;
    protected Instant m_now;

    public EvaluationContext() {
        this.m_variables = new HashMap<String, Object>();
        this.m_timezone = ZoneOffset.UTC;
        this.m_dateStyle = DateStyle.DAY_FIRST;
        this.m_now = Instant.now();
    }

    public EvaluationContext(Map<String, Object> variables, ZoneId timezone, DateStyle dateStyle) {
        this.m_variables = variables;
        this.m_timezone = timezone;
        this.m_dateStyle = dateStyle;
        this.m_now = Instant.now();
    }

    public EvaluationContext(Map<String, Object> variables, ZoneId timezone, DateStyle dateStyle, Instant now) {
        this.m_variables = variables;
        this.m_timezone = timezone;
        this.m_dateStyle = dateStyle;
        this.m_now = now;
    }

    public static EvaluationContext fromJson(String json) {
        return (EvaluationContext)s_gson.fromJson(json, EvaluationContext.class);
    }

    public Map<String, Object> getVariables() {
        return this.m_variables;
    }

    public Object resolveVariable(String path) {
        return this.resolveVariableInContainer(this.m_variables, path.toLowerCase(), path);
    }

    public void putVariable(String key, Object value) {
        this.m_variables.put(key, value);
    }

    public ZoneId getTimezone() {
        return this.m_timezone;
    }

    public DateStyle getDateStyle() {
        return this.m_dateStyle;
    }

    public void setDateStyle(DateStyle dateStyle) {
        this.m_dateStyle = dateStyle;
    }

    public Instant getNow() {
        return this.m_now;
    }

    public DateTimeFormatter getDateFormatter(boolean incTime) {
        return ExpressionUtils.getDateFormatter(this.m_dateStyle, incTime);
    }

    public DateParser getDateParser() {
        return new DateParser(LocalDate.now(), this.m_timezone, this.m_dateStyle);
    }

    private Object resolveVariableInContainer(Map<String, Object> container, String path, String originalPath) {
        String remainingPath;
        String item;
        if (path.contains(".")) {
            String[] parts = path.split("\\.", 2);
            item = parts[0];
            remainingPath = parts[1];
        } else {
            item = path;
            remainingPath = null;
        }
        container = ExpressionUtils.toLowerCaseKeys(container);
        if (!container.containsKey(item)) {
            throw new EvaluationError("Undefined variable: " + originalPath);
        }
        Object value = container.get(item);
        if (remainingPath != null && value != null) {
            if (!(value instanceof Map)) {
                throw new EvaluationError("Undefined variable: " + originalPath);
            }
            return this.resolveVariableInContainer((Map)value, remainingPath, originalPath);
        }
        if (value instanceof Map) {
            Map valueAsMap = (Map)value;
            if (valueAsMap.containsKey("*")) {
                return valueAsMap.get("*");
            }
            if (valueAsMap.containsKey("__default__")) {
                return valueAsMap.get("__default__");
            }
            return s_gson.toJson((Object)valueAsMap);
        }
        return value;
    }

    public static class Deserializer
    implements JsonDeserializer<EvaluationContext> {
        public EvaluationContext deserialize(JsonElement node, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject rootObj = node.getAsJsonObject();
            JsonObject varsObj = rootObj.get("variables").getAsJsonObject();
            ZoneId timezone = ZoneId.of((String)rootObj.get("timezone").getAsString());
            boolean dayFirst = rootObj.get("date_style").getAsString().equals("day_first");
            DateStyle dateStyle = dayFirst ? DateStyle.DAY_FIRST : DateStyle.MONTH_FIRST;
            Instant now = rootObj.has("now") ? ExpressionUtils.parseJsonDate(rootObj.get("now").getAsString()) : Instant.now();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (Map.Entry entry : varsObj.entrySet()) {
                variables.put((String)entry.getKey(), this.handleNode((JsonElement)entry.getValue(), (Type)((Object)Object.class), context));
            }
            return new EvaluationContext(variables, timezone, dateStyle, now);
        }

        public Object handleNode(JsonElement node, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (node.isJsonNull()) {
                return null;
            }
            if (node.isJsonPrimitive()) {
                return this.handlePrimitive(node.getAsJsonPrimitive());
            }
            if (node.isJsonArray()) {
                return this.handleArray(node.getAsJsonArray(), context);
            }
            return this.handleObject(node.getAsJsonObject(), context);
        }

        private Object handlePrimitive(JsonPrimitive node) {
            if (node.isBoolean()) {
                return node.getAsBoolean();
            }
            if (node.isString()) {
                return node.getAsString();
            }
            BigDecimal decimal = node.getAsBigDecimal();
            try {
                return decimal.intValueExact();
            }
            catch (ArithmeticException e) {
                return decimal;
            }
        }

        private Object handleArray(JsonArray node, JsonDeserializationContext context) {
            Object[] array = new Object[node.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.handleNode(node.get(i), (Type)((Object)Object.class), context);
            }
            return array;
        }

        private Object handleObject(JsonObject json, JsonDeserializationContext context) {
            HashMap map = new HashMap();
            for (Map.Entry entry : json.entrySet()) {
                map.put(entry.getKey(), this.handleNode((JsonElement)entry.getValue(), (Type)((Object)Object.class), context));
            }
            return map;
        }
    }
}

