/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions;

import io.rapidpro.expressions.evaluator.Evaluator;
import io.rapidpro.expressions.functions.CustomFunctions;
import io.rapidpro.expressions.functions.ExcelFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EvaluatorBuilder {
    protected char m_expressionPrefix = (char)64;
    protected Set<String> m_allowedTopLevels = new HashSet<String>();
    protected List<Class<?>> m_functionLibraries = new ArrayList();

    public EvaluatorBuilder() {
        this.m_functionLibraries.add(ExcelFunctions.class);
        this.m_functionLibraries.add(CustomFunctions.class);
    }

    public EvaluatorBuilder withExpressionPrefix(char expressionPrefix) {
        this.m_expressionPrefix = expressionPrefix;
        return this;
    }

    public EvaluatorBuilder withAllowedTopLevels(String[] topLevels) {
        this.m_allowedTopLevels = new HashSet<String>(Arrays.asList(topLevels));
        return this;
    }

    public EvaluatorBuilder addFunctionLibrary(Class<?> functionLibrary) {
        this.m_functionLibraries.add(functionLibrary);
        return this;
    }

    public Evaluator build() {
        return new Evaluator(this.m_expressionPrefix, this.m_allowedTopLevels, this.m_functionLibraries);
    }
}

