/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.evaluator;

import io.rapidpro.expressions.EvaluatedTemplate;
import io.rapidpro.expressions.EvaluationContext;
import io.rapidpro.expressions.EvaluationError;
import io.rapidpro.expressions.ExcellentLexer;
import io.rapidpro.expressions.ExcellentParser;
import io.rapidpro.expressions.evaluator.Conversions;
import io.rapidpro.expressions.evaluator.ExpressionVisitorImpl;
import io.rapidpro.expressions.functions.FunctionManager;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluator {
    protected static Logger logger = LoggerFactory.getLogger(Evaluator.class);
    private char m_expressionPrefix;
    private FunctionManager m_functionManager = new FunctionManager();
    private Set<String> m_allowedTopLevels;

    public Evaluator(char expressionPrefix, Set<String> allowedTopLevels, List<Class<?>> functionLibraries) {
        this.m_expressionPrefix = expressionPrefix;
        this.m_allowedTopLevels = allowedTopLevels;
        for (Class<?> functionLibrary : functionLibraries) {
            this.m_functionManager.addLibrary(functionLibrary);
        }
    }

    private static boolean isWordChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public EvaluatedTemplate evaluateTemplate(String template, EvaluationContext context) {
        return this.evaluateTemplate(template, context, false);
    }

    public EvaluatedTemplate evaluateTemplate(String template, EvaluationContext context, boolean urlEncode) {
        return this.evaluateTemplate(template, context, urlEncode, EvaluationStrategy.COMPLETE);
    }

    public EvaluatedTemplate evaluateTemplate(String template, EvaluationContext context, boolean urlEncode, EvaluationStrategy strategy) {
        char[] inputChars = template.toCharArray();
        StringBuilder output = new StringBuilder();
        ArrayList<String> errors = new ArrayList<String>();
        State state = State.BODY;
        StringBuilder currentExpression = new StringBuilder();
        boolean currentExpressionTerminated = false;
        int parenthesesLevel = 0;
        for (int pos = 0; pos < inputChars.length; ++pos) {
            char nextNextCh;
            char ch = inputChars[pos];
            char nextCh = pos < inputChars.length - 1 ? inputChars[pos + 1] : (char)'\u0000';
            char c = nextNextCh = pos < inputChars.length - 2 ? inputChars[pos + 2] : (char)'\u0000';
            if (state == State.BODY) {
                if (ch == this.m_expressionPrefix && (Evaluator.isWordChar(nextCh) || nextCh == '(')) {
                    state = State.PREFIX;
                    currentExpression = new StringBuilder("" + ch);
                } else if (ch == this.m_expressionPrefix && nextCh == this.m_expressionPrefix) {
                    state = State.ESCAPED_PREFIX;
                } else {
                    output.append(ch);
                }
            } else if (state == State.PREFIX) {
                if (Evaluator.isWordChar(ch)) {
                    state = State.IDENTIFIER;
                } else if (ch == '(') {
                    state = State.BALANCED;
                    ++parenthesesLevel;
                }
                currentExpression.append(ch);
            } else if (state == State.IDENTIFIER) {
                currentExpression.append(ch);
            } else if (state == State.BALANCED) {
                if (ch == '(') {
                    ++parenthesesLevel;
                } else if (ch == ')') {
                    --parenthesesLevel;
                } else if (ch == '\"') {
                    state = State.STRING_LITERAL;
                }
                currentExpression.append(ch);
                if (parenthesesLevel == 0) {
                    currentExpressionTerminated = true;
                }
            } else if (state == State.STRING_LITERAL) {
                if (ch == '\"') {
                    state = State.BALANCED;
                }
                currentExpression.append(ch);
            } else if (state == State.ESCAPED_PREFIX) {
                state = State.BODY;
                output.append(ch);
            }
            if (state == State.IDENTIFIER && (nextCh == '\u0000' || !Evaluator.isWordChar(nextCh) && nextCh != '.' || nextCh == '.' && !Evaluator.isWordChar(nextNextCh))) {
                currentExpressionTerminated = true;
            }
            if (!currentExpressionTerminated) continue;
            output.append(this.resolveExpressionBlock(currentExpression.toString(), context, urlEncode, strategy, errors));
            currentExpression = null;
            currentExpressionTerminated = false;
            state = State.BODY;
        }
        if (!currentExpressionTerminated && StringUtils.isNotEmpty((CharSequence)currentExpression)) {
            output.append(currentExpression.toString());
        }
        return new EvaluatedTemplate(output.toString(), errors);
    }

    protected String resolveExpressionBlock(String expression, EvaluationContext context, boolean urlEncode, EvaluationStrategy strategy, List<String> errors) {
        try {
            String topLevel;
            String body = expression.substring(1);
            if (!body.startsWith("(") && !this.m_allowedTopLevels.contains(topLevel = StringUtils.split((String)body, (char)'.')[0].toLowerCase())) {
                return expression;
            }
            Object evaluated = this.evaluateExpression(body, context, strategy);
            String rendered = Conversions.toString(evaluated, context);
            return urlEncode ? ExpressionUtils.urlquote(rendered) : rendered;
        }
        catch (EvaluationError ex) {
            logger.debug("Unable to evaluate expression", (Throwable)ex);
            errors.add(ex.getMessage());
            return expression;
        }
    }

    public Object evaluateExpression(String expression, EvaluationContext context) throws EvaluationError {
        return this.evaluateExpression(expression, context, EvaluationStrategy.COMPLETE);
    }

    public Object evaluateExpression(String expression, EvaluationContext context, EvaluationStrategy strategy) throws EvaluationError {
        String resolved;
        ExcellentParser.ParseContext tree;
        ExcellentLexer lexer = new ExcellentLexer((CharStream)new ANTLRInputStream(expression));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExcellentParser parser = new ExcellentParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            tree = parser.parse();
            if (logger.isDebugEnabled()) {
                logger.debug("Expression '{}' parsed as {}", (Object)expression, (Object)tree.toStringTree());
            }
        }
        catch (ParseCancellationException ex) {
            Token token;
            String message = null;
            if (ex.getCause() instanceof NoViableAltException && (token = ((NoViableAltException)ex.getCause()).getOffendingToken()) != null && token.getType() != -1) {
                message = "Expression error at: " + token.getText();
            }
            if (message == null) {
                message = "Expression is invalid";
            }
            throw new EvaluationError(message, ex);
        }
        if (strategy == EvaluationStrategy.RESOLVE_AVAILABLE && (resolved = this.resolveAvailable(tokens, context)) != null) {
            return resolved;
        }
        ExpressionVisitorImpl visitor = new ExpressionVisitorImpl(this.m_functionManager, context);
        return visitor.visit((ParseTree)tree);
    }

    protected String resolveAvailable(CommonTokenStream tokens, EvaluationContext context) {
        boolean hasMissing = false;
        ArrayList<Object> outputComponents = new ArrayList<Object>();
        for (int t = 0; t < tokens.size() - 1; ++t) {
            Token token = tokens.get(t);
            Token token2 = tokens.get(t + 1);
            if (token.getType() == 20 && token2.getType() != 2) {
                try {
                    outputComponents.add(context.resolveVariable(token.getText()));
                }
                catch (EvaluationError ex) {
                    hasMissing = true;
                    outputComponents.add(token);
                }
                continue;
            }
            outputComponents.add(token);
        }
        if (!hasMissing) {
            return null;
        }
        StringBuilder output = new StringBuilder(String.valueOf(this.m_expressionPrefix));
        for (Object e : outputComponents) {
            String compVal = e instanceof Token ? ((Token)e).getText() : Conversions.toRepr(e, context);
            output.append(compVal);
        }
        return output.toString();
    }

    private static enum State {
        BODY,
        PREFIX,
        IDENTIFIER,
        BALANCED,
        STRING_LITERAL,
        ESCAPED_PREFIX;

    }

    public static enum EvaluationStrategy {
        COMPLETE,
        RESOLVE_AVAILABLE;

    }
}

