/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.functions;

import io.rapidpro.expressions.EvaluationContext;
import io.rapidpro.expressions.evaluator.Conversions;
import io.rapidpro.expressions.functions.annotations.BooleanDefault;
import io.rapidpro.expressions.functions.annotations.IntegerDefault;
import io.rapidpro.expressions.functions.annotations.StringDefault;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CustomFunctions {
    public static String field(EvaluationContext ctx, Object text, Object index, @StringDefault(value=" ") Object delimiter) {
        String _text = Conversions.toString(text, ctx);
        int _index = Conversions.toInteger(index, ctx);
        String _delimiter = Conversions.toString(delimiter, ctx);
        String[] splits = StringUtils.splitByWholeSeparator((String)_text, (String)_delimiter);
        if (_index < 1) {
            throw new RuntimeException("Field index cannot be less than 1");
        }
        if (_index <= splits.length) {
            return splits[_index - 1];
        }
        return "";
    }

    public static String first_word(EvaluationContext ctx, Object text) {
        return CustomFunctions.word(ctx, text, 1, false);
    }

    public static String percent(EvaluationContext ctx, Object number) {
        BigDecimal percent = Conversions.toDecimal(number, ctx).multiply(new BigDecimal(100));
        return Conversions.toInteger(percent, ctx) + "%";
    }

    public static String read_digits(EvaluationContext ctx, Object text) {
        String _text = Conversions.toString(text, ctx).trim();
        if (StringUtils.isEmpty((CharSequence)_text)) {
            return "";
        }
        if (_text.startsWith("+")) {
            _text = _text.substring(1);
        }
        if (_text.length() == 9) {
            return StringUtils.join((char[])_text.substring(0, 3).toCharArray(), (char)' ') + " , " + StringUtils.join((char[])_text.substring(3, 5).toCharArray(), (char)' ') + " , " + StringUtils.join((char[])_text.substring(5).toCharArray(), (char)' ');
        }
        if (_text.length() % 3 == 0 && _text.length() > 3) {
            List<String> chunks = CustomFunctions.chunk(_text, 3);
            return StringUtils.join((char[])StringUtils.join(chunks, (char)',').toCharArray(), (char)' ');
        }
        if (_text.length() % 4 == 0) {
            List<String> chunks = CustomFunctions.chunk(_text, 4);
            return StringUtils.join((char[])StringUtils.join(chunks, (char)',').toCharArray(), (char)' ');
        }
        return StringUtils.join((char[])_text.toCharArray(), (char)',');
    }

    public static String remove_first_word(EvaluationContext ctx, Object text) {
        String _text = StringUtils.stripStart((String)Conversions.toString(text, ctx), null);
        String firstWord = CustomFunctions.first_word(ctx, _text);
        if (StringUtils.isNotEmpty((CharSequence)firstWord)) {
            return StringUtils.stripStart((String)_text.substring(firstWord.length()), null);
        }
        return "";
    }

    public static String word(EvaluationContext ctx, Object text, Object number, @BooleanDefault(value=false) Object bySpaces) {
        return CustomFunctions.word_slice(ctx, text, number, Conversions.toInteger(number, ctx) + 1, bySpaces);
    }

    public static int word_count(EvaluationContext ctx, Object text, @BooleanDefault(value=false) Object bySpaces) {
        String _text = Conversions.toString(text, ctx);
        boolean _bySpaces = Conversions.toBoolean(bySpaces, ctx);
        return CustomFunctions.getWords(_text, _bySpaces).size();
    }

    public static String word_slice(EvaluationContext ctx, Object text, Object start, @IntegerDefault(value=0) Object stop, @BooleanDefault(value=false) Object bySpaces) {
        String _text = Conversions.toString(text, ctx);
        int _start = Conversions.toInteger(start, ctx);
        Integer _stop = Conversions.toInteger(stop, ctx);
        boolean _bySpaces = Conversions.toBoolean(bySpaces, ctx);
        if (_start == 0) {
            throw new RuntimeException("Start word cannot be zero");
        }
        if (_start > 0) {
            --_start;
        }
        if (_stop == 0) {
            _stop = null;
        } else if (_stop > 0) {
            _stop = _stop - 1;
        }
        List<String> words = CustomFunctions.getWords(_text, _bySpaces);
        List<String> selection = ExpressionUtils.slice(words, _start, _stop);
        return StringUtils.join(selection, (char)' ');
    }

    private static List<String> getWords(String text, boolean bySpaces) {
        if (bySpaces) {
            ArrayList<String> words = new ArrayList<String>();
            for (String split : text.split("\\s+")) {
                if (!StringUtils.isNotEmpty((CharSequence)split)) continue;
                words.add(split);
            }
            return words;
        }
        return Arrays.asList(ExpressionUtils.tokenize(text));
    }

    private static List<String> chunk(String text, int size) {
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < text.length(); i += size) {
            chunks.add(StringUtils.substring((String)text, (int)i, (int)(i + size)));
        }
        return chunks;
    }
}

