/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.dates;

import io.rapidpro.expressions.dates.DateStyle;
import io.rapidpro.expressions.utils.ExpressionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.Temporal;

public class DateParser {
    protected static final Map<String, Integer> MONTHS_BY_ALIAS;
    protected static final int AM = 0;
    protected static final int PM = 1;
    protected static final Component[][] DATE_SEQUENCES_DAY_FIRST;
    protected static final Component[][] DATE_SEQUENCES_MONTH_FIRST;
    protected static final Component[][] TIME_SEQUENCES;
    protected final LocalDate m_now;
    protected final ZoneId m_timezone;
    protected final DateStyle m_dateStyle;

    public DateParser(LocalDate now, ZoneId timezone, DateStyle dateStyle) {
        this.m_now = now;
        this.m_timezone = timezone;
        this.m_dateStyle = dateStyle;
    }

    public Temporal auto(String text) {
        return this.parse(text, Mode.AUTO);
    }

    public OffsetTime time(String text) {
        return (OffsetTime)this.parse(text, Mode.TIME);
    }

    protected Temporal parse(String text, Mode mode) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        if (text.length() >= 16) {
            try {
                return OffsetDateTime.parse((CharSequence)text).toZonedDateTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Pattern pattern = Pattern.compile("([0-9]+|\\p{L}+)");
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group(0));
        }
        ArrayList<Map<Component, Integer>> tokenPossibilities = new ArrayList<Map<Component, Integer>>();
        for (String token : tokens) {
            Map<Component, Integer> possibilities = DateParser.getTokenPossibilities(token, mode);
            if (possibilities.size() <= 0) continue;
            tokenPossibilities.add(possibilities);
        }
        List<Component[]> sequences = DateParser.getPossibleSequences(mode, tokenPossibilities.size(), this.m_dateStyle);
        block4: for (Component[] sequence : sequences) {
            LinkedHashMap<Component, Integer> match = new LinkedHashMap<Component, Integer>();
            for (int c = 0; c < sequence.length; ++c) {
                Component component = sequence[c];
                Integer value = (Integer)((Map)tokenPossibilities.get(c)).get((Object)component);
                match.put(component, value);
                if (value == null) continue block4;
            }
            Temporal obj = DateParser.makeResult(match, this.m_now, this.m_timezone);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    protected static List<Component[]> getPossibleSequences(Mode mode, int length, DateStyle dateStyle) {
        Component[][] dateSequences;
        ArrayList<Component[]> sequences = new ArrayList<Component[]>();
        Component[][] componentArray = dateSequences = dateStyle.equals((Object)DateStyle.DAY_FIRST) ? DATE_SEQUENCES_DAY_FIRST : DATE_SEQUENCES_MONTH_FIRST;
        if (mode == Mode.DATE || mode == Mode.AUTO) {
            for (Component[] seq : dateSequences) {
                if (seq.length != length) continue;
                sequences.add(seq);
            }
        } else if (mode == Mode.TIME) {
            for (Component[] seq : TIME_SEQUENCES) {
                if (seq.length != length) continue;
                sequences.add(seq);
            }
        }
        if (mode == Mode.DATETIME || mode == Mode.AUTO) {
            for (Component[] dateSeq : dateSequences) {
                for (Component[] timeSeq : TIME_SEQUENCES) {
                    if (dateSeq.length + timeSeq.length != length) continue;
                    sequences.add((Component[])ArrayUtils.addAll((Object[])dateSeq, (Object[])timeSeq));
                }
            }
        }
        return sequences;
    }

    protected static Map<Component, Integer> getTokenPossibilities(String token, Mode mode) {
        HashMap<Component, Integer> possibilities;
        block20: {
            token = token.toLowerCase().trim();
            possibilities = new HashMap<Component, Integer>();
            try {
                int asInt = Integer.parseInt(token);
                if (mode != Mode.TIME) {
                    if (asInt >= 1 && asInt <= 9999 && (token.length() == 2 || token.length() == 4)) {
                        possibilities.put(Component.YEAR, asInt);
                    }
                    if (asInt >= 1 && asInt <= 12) {
                        possibilities.put(Component.MONTH, asInt);
                    }
                    if (asInt >= 1 && asInt <= 31) {
                        possibilities.put(Component.DAY, asInt);
                    }
                }
                if (mode != Mode.DATE) {
                    if (asInt >= 0 && asInt <= 23) {
                        possibilities.put(Component.HOUR, asInt);
                    }
                    if (asInt >= 0 && asInt <= 59) {
                        possibilities.put(Component.MINUTE, asInt);
                    }
                    if (asInt >= 0 && asInt <= 59) {
                        possibilities.put(Component.SECOND, asInt);
                    }
                    if (token.length() == 3 || token.length() == 6 || token.length() == 9) {
                        int nano = 0;
                        if (token.length() == 3) {
                            nano = asInt * 1000000;
                        } else if (token.length() == 6) {
                            nano = asInt * 1000;
                        } else if (token.length() == 9) {
                            nano = asInt;
                        }
                        possibilities.put(Component.NANO, nano);
                    }
                    if (token.length() == 4) {
                        int hour = asInt / 100;
                        int minute = asInt - hour * 100;
                        if (hour >= 1 && hour <= 24 && minute >= 1 && minute <= 59) {
                            possibilities.put(Component.HOUR_AND_MINUTE, asInt);
                        }
                    }
                }
            }
            catch (NumberFormatException ex) {
                Integer month;
                if (mode != Mode.TIME && (month = MONTHS_BY_ALIAS.get(token)) != null) {
                    possibilities.put(Component.MONTH, month);
                }
                if (mode == Mode.DATE) break block20;
                boolean isAmMarker = token.equals("am");
                boolean isPmMarker = token.equals("pm");
                if (isAmMarker || isPmMarker) {
                    possibilities.put(Component.AM_PM, isAmMarker ? 0 : 1);
                }
                if (!token.equals("z")) break block20;
                possibilities.put(Component.OFFSET, 0);
            }
        }
        return possibilities;
    }

    protected static Temporal makeResult(Map<Component, Integer> values, LocalDate now, ZoneId timezone) {
        LocalDate date = null;
        LocalTime time = null;
        if (values.containsKey((Object)Component.MONTH)) {
            int year = DateParser.yearFrom2Digits(ExpressionUtils.getOrDefault(values, Component.YEAR, now.getYear()), now.getYear());
            int month = values.get((Object)Component.MONTH);
            int day = ExpressionUtils.getOrDefault(values, Component.DAY, 1);
            try {
                date = LocalDate.of((int)year, (int)month, (int)day);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        if (values.containsKey((Object)Component.HOUR) && values.containsKey((Object)Component.MINUTE) || values.containsKey((Object)Component.HOUR_AND_MINUTE)) {
            int nano;
            int second;
            int minute;
            int hour;
            if (values.containsKey((Object)Component.HOUR_AND_MINUTE)) {
                int combined = values.get((Object)Component.HOUR_AND_MINUTE);
                hour = combined / 100;
                minute = combined - hour * 100;
                second = 0;
                nano = 0;
            } else {
                hour = values.get((Object)Component.HOUR);
                minute = values.get((Object)Component.MINUTE);
                second = ExpressionUtils.getOrDefault(values, Component.SECOND, 0);
                nano = ExpressionUtils.getOrDefault(values, Component.NANO, 0);
                if (hour < 12 && ExpressionUtils.getOrDefault(values, Component.AM_PM, 0) == 1) {
                    hour += 12;
                } else if (hour == 12 && ExpressionUtils.getOrDefault(values, Component.AM_PM, 1) == 0) {
                    hour -= 12;
                }
            }
            try {
                time = LocalTime.of((int)hour, (int)minute, (int)second, (int)nano);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        if (values.containsKey((Object)Component.OFFSET)) {
            timezone = ZoneOffset.ofTotalSeconds((int)values.get((Object)Component.OFFSET));
        }
        if (date != null && time != null) {
            return ZonedDateTime.of(date, time, (ZoneId)timezone);
        }
        if (date != null) {
            return date;
        }
        if (time != null) {
            return ZonedDateTime.of((LocalDate)now, time, (ZoneId)timezone).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    protected static int yearFrom2Digits(int shortYear, int currentYear) {
        if (shortYear < 100 && Math.abs((shortYear += currentYear - currentYear % 100) - currentYear) >= 50) {
            if (shortYear < currentYear) {
                return shortYear + 100;
            }
            return shortYear - 100;
        }
        return shortYear;
    }

    protected static Map<String, Integer> loadMonthAliases(String file) throws IOException {
        String line;
        InputStream in = DateParser.class.getClassLoader().getResourceAsStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int month = 1;
        while ((line = reader.readLine()) != null) {
            for (String alias : line.split(",")) {
                map.put(alias, month);
            }
            ++month;
        }
        reader.close();
        return map;
    }

    static {
        try {
            MONTHS_BY_ALIAS = DateParser.loadMonthAliases("month.aliases");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DATE_SEQUENCES_DAY_FIRST = new Component[][]{{Component.DAY, Component.MONTH, Component.YEAR}, {Component.MONTH, Component.DAY, Component.YEAR}, {Component.YEAR, Component.MONTH, Component.DAY}, {Component.DAY, Component.MONTH}, {Component.MONTH, Component.DAY}, {Component.MONTH, Component.YEAR}};
        DATE_SEQUENCES_MONTH_FIRST = new Component[][]{{Component.MONTH, Component.DAY, Component.YEAR}, {Component.DAY, Component.MONTH, Component.YEAR}, {Component.YEAR, Component.MONTH, Component.DAY}, {Component.MONTH, Component.DAY}, {Component.DAY, Component.MONTH}, {Component.MONTH, Component.YEAR}};
        TIME_SEQUENCES = new Component[][]{{Component.HOUR_AND_MINUTE}, {Component.HOUR, Component.MINUTE}, {Component.HOUR, Component.MINUTE, Component.AM_PM}, {Component.HOUR, Component.MINUTE, Component.SECOND}, {Component.HOUR, Component.MINUTE, Component.SECOND, Component.AM_PM}, {Component.HOUR, Component.MINUTE, Component.SECOND, Component.NANO}, {Component.HOUR, Component.MINUTE, Component.SECOND, Component.NANO, Component.OFFSET}};
    }

    protected static enum Component {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        HOUR_AND_MINUTE,
        SECOND,
        NANO,
        AM_PM,
        OFFSET;

    }

    protected static enum Mode {
        DATE,
        DATETIME,
        TIME,
        AUTO;

    }
}

