/*
 * Decompiled with CFR 0.152.
 */
package io.rapidpro.expressions.utils;

import io.rapidpro.expressions.dates.DateStyle;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public final class ExpressionUtils {
    protected static DateTimeFormatter ISO_DATETIME_FORMAT = DateTimeFormatter.ofPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSSxxx");
    protected static DateTimeFormatter ISO_DATETIME_FORMAT_NO_SECOND_FRACTION = DateTimeFormatter.ofPattern((String)"yyyy-MM-dd'T'HH:mm:ssxxx");
    protected static DateTimeFormatter JSON_DATETIME_FORMAT = DateTimeFormatter.ofPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static MathContext MATH = new MathContext(28, RoundingMode.HALF_EVEN);

    private ExpressionUtils() {
    }

    public static <T> List<T> slice(List<T> list, Integer start, Integer stop) {
        int size = list.size();
        if (start == null) {
            start = 0;
        } else if (start < 0) {
            start = size + start;
        }
        if (stop == null) {
            stop = size;
        } else if (stop < 0) {
            stop = size + stop;
        }
        if (start >= size || stop <= 0 || start >= stop) {
            return Collections.emptyList();
        }
        start = Math.max(0, start);
        stop = Math.min(size, stop);
        return list.subList(start, stop);
    }

    public static BigDecimal decimalPow(BigDecimal number, BigDecimal power) {
        return new BigDecimal(Math.pow(number.doubleValue(), power.doubleValue()), MATH);
    }

    public static BigDecimal decimalRound(BigDecimal number, int numDigits, RoundingMode rounding) {
        BigDecimal rounded = number.setScale(numDigits, rounding);
        if (numDigits < 0) {
            rounded = rounded.setScale(0, 7);
        }
        return rounded;
    }

    public static String urlquote(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DateTimeFormatter getDateFormatter(DateStyle dateStyle, boolean incTime) {
        String format = dateStyle.equals((Object)DateStyle.DAY_FIRST) ? "dd-MM-yyyy" : "MM-dd-yyyy";
        return DateTimeFormatter.ofPattern((String)(incTime ? format + " HH:mm" : format));
    }

    public static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public static String[] tokenize(String text) {
        int len = text.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            int ch32 = text.codePointAt(i);
            if (ExpressionUtils.isEmojiChar(ch32)) {
                list.add(new String(Character.toChars(ch32)));
                i += Character.isHighSurrogate(ch) ? 2 : 1;
                continue;
            }
            if (ExpressionUtils.isWordChar(ch)) {
                int wordStart = i;
                while (i < len && ExpressionUtils.isWordChar(text.codePointAt(i))) {
                    ++i;
                }
                list.add(text.substring(wordStart, i));
                continue;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String formatIsoDate(ZonedDateTime value) {
        if (value == null) {
            return null;
        }
        if (value.getNano() == 0) {
            return ISO_DATETIME_FORMAT_NO_SECOND_FRACTION.format((TemporalAccessor)value);
        }
        return ISO_DATETIME_FORMAT.format((TemporalAccessor)value);
    }

    public static String formatJsonDate(Instant value) {
        if (value == null) {
            return null;
        }
        return JSON_DATETIME_FORMAT.format((TemporalAccessor)value.atOffset(ZoneOffset.UTC));
    }

    public static Instant parseJsonDate(String value) {
        if (value == null) {
            return null;
        }
        return LocalDateTime.parse((CharSequence)value, (DateTimeFormatter)JSON_DATETIME_FORMAT).atOffset(ZoneOffset.UTC).toInstant();
    }

    public static <T> Map<String, T> toLowerCaseKeys(Map<String, T> map) {
        HashMap<String, T> res = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            res.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return res;
    }

    static boolean isWordChar(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 95;
    }

    static boolean isEmojiChar(int ch) {
        return ch >= 8352 && ch <= 8399 || ch >= 9728 && ch <= 10175 || ch >= 127744 && ch <= 128511 || ch >= 128512 && ch <= 128591 || ch >= 128640 && ch <= 128767 || ch >= 129280 && ch <= 129535;
    }
}

